#include	"HeatSource_def.h"

#include	<string.h>
#include	<stdlib.h>
#include	"infrastructure/Metaclass.h"

static	char*	class_name = "the heatSource_def";
Type*	HeatSource_def_Type_pointer;


HeatSource_def::HeatSource_def(Metaclass* meta)  :  X_def(meta)
{
	DEBUG	<< "HeatSource_def::HeatSource_def(" << meta->oid() << ")\n";

	name(class_name);
	directType(TYPE_OF(HeatSource_def));

	cout << "Total output power? ";
	float p;
	cin >> p;
	the_output = p;

	cout << "Radiant / convective split? ";
	cin >> p;
	the_rad_conv_split = p;
};

HeatSource_def::HeatSource_def(Power& output, Proportion& split)
				: X_def(), the_output(output),
				  the_rad_conv_split(split)
{
	DEBUG	<< "HeatSource_def::HeatSource_def(Power& output, Proportion& split)\n";

	name(class_name);
	directType(TYPE_OF(HeatSource_def));

};

HeatSource_def::HeatSource_def(APL* theAPL) : X_def(theAPL)
{};

HeatSource_def::~HeatSource_def()
{
	DEBUG << "HeatSource_def::~HeatSource_def()\n";
};


void    HeatSource_def::description(Metaclass* meta, ostream& s)
{
        s << indent << "total output power: \n";
	s << indent << "radiant/convective split: \n";
};
