#ifndef HEATSOURCE_H
#define HEATSOURCE_H

/* The actual physical thing */

#include	"dimensions/Power.h"
#include	"dimensions/Proportion.h"
#include	"infrastructure/EKSObject.h"
class	HeatSource_def;
////class Schedule;

extern	Type*	HeatSource_Type_pointer;


enum	state_enum { OFF, ON };


class HeatSource : public EKSObject {
protected:
////	Schedule*	theSchedule;
	Power		the_output;
	Proportion	the_rad_conv_split;
	state_enum	theState;	//values OFF=0 or ON=1
public:
        HeatSource(Metaclass* meta, HeatSource_def* def);
////        HeatSource(Power& output, Proportion& split,
////		       Schedule* sched = NULLPTR(Schedule));
	HeatSource(APL* theAPL);
	~HeatSource();

	Type*	getDirectType();

	void 			setState(state_enum state);

////	Schedule* 		schedule();
	Power 			output();
	Power 			convectiveOutput();
	Power 			radiantOutput();
};
 

inline
Type*	HeatSource::getDirectType()
{
	return TYPE_OF(HeatSource);
};

inline
void	HeatSource::setState(state_enum state)
{
	theState = state;
};

inline
Power	HeatSource::output()
{
	return theState == ON ? the_output : Power(0);
};

inline
Power	HeatSource::convectiveOutput()
{
	if (theState == ON)
		return the_output * (1 - the_rad_conv_split);
	else
		return Power(0);
};

inline
Power	HeatSource::radiantOutput()
{
	if (theState == ON)
		return the_output * the_rad_conv_split;
	else
		return Power(0);
};

#endif
