#include "Convection_fd_1.h"
#include "Surface.h"
#include "Area.h"
#include "Volume.h"
#include "SpecificHeatCapacity.h"
#include "ThermalResistance.h"


Convection_fd_1::Convection_fd(Metaclass* meta, Convection_fd_def* def)
                                : (meta, (Convection_def*) def)
{
	DEBUG << "Convection_fd_1::Convection_fd_1(Metaclass* meta, Convection_fd_def* def)\n";

	name(class_name);
/**/	my_type = class_type;
};

Convection_fd_1::Convection_fd_1(Convection_fd_1& c) : ((Convection&)c)
{
	DEBUG << "Convection_fd_1::Convection_fd_1(Convection_fd_1& c)\n";

	name(class_name);
/**/	my_type = class_type;
}

Convection_fd_1::~Convection_fd_1()
{
	DEBUG << "Convection_fd_1::~Convection_fd_1()\n";
}


float	Convection_fd_1::heat_transfer_coeff(AirVolume* air, Surface*   surf)
{
	DEBUG1	<< "float Convection_fd_1::heat_transfer_coef(AirVolume* air, Surface* surf)"\n;

        // This function returns the convective heat transfer coefficient
        // which is recommented by CIBSE or ASHRAE.
        return 8.0;
};



Convection_fd_1& Convection_fd::operator=(Convection_fd& c)
{
        DEBUG1 << "Convection_fd_1& Convection_fd_1::operator=(Convection_fd_1& c)\n";

        (void) Convection::operator=((Convection&)c);

        return *this;
}


/*
** Lumped parameter air volume state equation.
*/
Equation_set   Convection_fd_1::generate_equations( State_vector* state_vector,
                                                  EKSObject*  airvol,
						  Equation_iterator  airvol_eqn_iter)
{
        DEBUG1 << "Equation_set*   Convection_fd_1::generate_equations(State_vector* state_vector,\n";
        DEBUG1 << "         EKSObject*  airvol, Equation_iterator  airvol_eqn_iter)\n";

/*==============================================================================
Inputs:
        state_vector - State_vector of air-volume.
        airvol - object.
        airvol_eqn_iter - object's old eqns.
What the function does:
        1. calculate the air capacity.
        2. create an air equation with only one sefl-coupling coefficient.
        3. set coefficient, gain, resistance to 0.
        4. store capacity.
        5. encapsulate equation into equation_set and return.
Note:
==============================================================================*/

					// Create equation set for generated eqns
        Equation_set   eqn_set();

					// Get the required data from airvol.
        SpecificHeatCapacity capacity = airvol->substance().density().value() *
                               airvol->substance().specificHeatCapacity().value() *
                               airvol->volume().value();
        ThermalResistance resist(0);

				// Generate the first (only) air equation.
        float	self_coupling_coeff = 0;
        Energy	gain(0);
        
        Equation*	eqn = new Equation((*state_vector)[0], ENERGY,
					    self_coupling_coeff, gain,
					    resist, capacity);

        eqn_set->append(eqn);

					// delete old equations
	if (layer_eqn_iter.size() != 0) {
		layer_eqn_iter(RESET);
		while (eq = layer_eqn_iter(FORWARD))
			delete eq;

        return eqn_set;
};

Equation_set* Convection_fd_1::combine_equations(Equation_iterator airvol1_eqn_iter,
					       State_variable* airvol1_surface_node,
					       Equation_iterator  airvol2_eqn_iter,
					       State_variable* airvol2_surface_node)
{
	
	DEBUG1 << "Equation_set* Conduction_fd_1::combine_equations(Equation_iterator  airvol1_eqn_iter,\n";
	DEBUG1 << "	  State_variable*  airvol1_surface_node, Equation_iterator  airvol2_eqn_iter,\n";
	DEBUG1 << "	  State_variable*  airvol2_surface_node)\n";

					// get 1st equation
	Equation*	eqn1;
	airvol1_eqn_iter(RESET)
	while (eqn1 = airvol1_eqn_iter(FORWARD))
		if (airvol1_surface_node == eqn1->state_variable())
			break;
	if (eqn1 = NULLPTR(Equation)) {
		cerr << "Conduction::combine equations(): eqn for sv1 not found";
		exit(1);
	};
					// get 2nd equation
	Equation*	eqn2;
	airvol2_eqn_iter(RESET)
	while (eqn2 = airvol2_eqn_iter(FORWARD))
		if (airvol2_surface_node == eqn2->state_variable())
			break;
	if (eqn2 = NULLPTR(Equation)) {
		cerr << "Conduction::combine equations(): eqn for sv2 not found";
		exit(1);
	};
					// update self coupling coefficients
					// add new coupling coefficients
					// concatenate equation sets and return
	Equation_set	eqn_set = airvol1_eqn_iter;
	eqn_set += airvol2_eqn_iter;

	return eqn_set;
};

/*
** Create convective heat transfer couplings between the air
** and the surfaces in the room.
*/
void    Convection_fd_1::add_coupling(Equation__iterator  airvol1_eqn_iter,
				    State_variable*  node_in_airvol1,
				    Equation_iterator  region2_eqn_iter,
				    State_variable*  node_in_region2,
				    EKSObject*  data_supplier)
{
	DEBUG1 << "void Conduction_fd_1::add_coupling(Equation_iterator  airvol1_eqn_iter,\n";
	DEBUG1 << "	  State_variable*  airvol1_surface_node, Equation_iterator  airvol2_eqn_iter,\n";
	DEBUG1 << "	  State_variable*  airvol2_surface_node, EKSObject*  data_supplier)\n";

/*==============================================================================
Inputs:
        airvol1_eqns		- equation_set of AirVolume.
        region2_eqns		- equation_set of Surface.
	data_supplier		- Surface (gives area & inclination)
What the function does:
        1. collect all the data.
        2. calculate the new coefficient.
        3. find the self coupling coefficient and get the value.
        4. modify the self coupling coefficient. c=c+new_value.
        5. create a cross coupling coefficient and add to the list in Equation.
 
==============================================================================*/

					// Get the equations to be coupled.
	Equation*	air_eqn;
        air_eqn = airvol_eqn_iter[0];
//					NB Assumed only 1 air equation, otherwise
//	airvol1_eqn_iter(RESET)
//	while (eqn1 = airvol1_eqn_iter(FORWARD))
//		if (airvol1_surface_node == eqn1->state_variable())
//			break;
//	if (eqn1 = NULLPTR(Equation)) {
//		cerr << "Conduction::ad_coupling(): eqn for air sv not found";
//		exit(1);
//	};

	Equation*	surface_eqn;
	region2_eqn_iter(RESET)
	while (surface_eqn = region2_eqn_iter(FORWARD))
		if (region2_surface_node == surface_eqn->state_variable())
			break;
	if (surface_eqn = NULLPTR(Equation)) {
		cerr << "Conduction::add_coupling(): eqn for surface sv not found";
		exit(1);
	};

        SpecificHeatCapacity	air_capacity = air_eqn->capacity();
        SpecificHeatCapacity	surface_capacity = surface_eqn->capacity();
        ThermalResistance	surface_resistance = surface_eqn->resistance();
	Surface*		surface = (Surface*)data_supplier;
        Area			surface_area = surface->area();

				// calculate heat transfer coeff
	Volume	air_volume = ((AirVolume*)node_in_airvol1->owner())->volume();
	float	htf = heat_transfer_coeff(air_volume, surface);

       				 // Modify air equation.
        float	new_coeff = (surface_area
				  / ( surface_resistance/2 + 1/htf)
				  / air_capacity)
						.value();	// ditch type info
        float	old_coeff = air_eqn->coefficient_value(node_in_airvol1);
        float	modified_coeff = old_coeff - new_coeff;
        air_eqn->change_coefficient(node_in_airvol1, modified_coeff);
        air_eqn->append_coefficient(node_in_region2, new_coeff);

        // For surface equation.
        new_coeff = (1 / (surface_resistance/2 + 1/heat_transfer_coeff)
				  /surface_capacity)
						.value();	// ditch type info
	old_coeff = surface_eqn->coefficient_value(node_in_region2);
        modified_coeff = old_coeff - new_coeff;
        surface_eqn->change_coefficient(node_in_region2, modified_coeff);
        surface_eqn->append_coefficient(node_in_airvol1, new_coeff);
};

void    Convection_fd_1::inject_energy(Equation_iterator  airvol_eqn_iter,
				     State_variable*  node_in_airvol,
				     Energy  gain)
{
	DEBUG1	<< "void   Convection_fd_1::inject_energy(Equation_iterator  airvol_eqn_iter,"\n;
	DEBUG1	<< "		     State_variable*  node_in_airvol,"\n;
	DEBUG1	<< "		     Energy  gain)"\n;

					// Get the equation to be modified.
	Equation*	air_eqn;
        air_eqn = airvol_eqn_iter[0];
//					NB Assumed only 1 air equation, otherwise
//	airvol1_eqn_iter(RESET)
//	while (eqn1 = airvol1_eqn_iter(FORWARD))
//		if (airvol1_surface_node == eqn1->state_variable())
//			break;
//	if (eqn1 = NULLPTR(Equation)) {
//		cerr << "Conduction::ad_coupling(): eqn for air sv not found";
//		exit(1);
//	};
        air_eqn = airvol_eqn_iter[0];

        air_eqn->add_gain(gain);
};
