#include	"building/Construction_es_def.h"

#include	<string.h>
#include	"infrastructure/Metaclass.h"


static	char*	class_name = "the_construction_es_def";
Type*	Construction_es_def_Type_pointer;


Construction_es_def::Construction_es_def(Metaclass* meta)
					: Construction_basic_def(meta)
{
	DEBUG	<< "Construction_es_def::Construction_es_def(" << meta->oid() << ")\n";

	name(class_name);
	directType(TYPE_OF(Construction_es_def));

	char	buffer[256];
	cout << "which Conduction theory object for Construction (name)? ";
	cin >> buffer;
	the_conduction_name = strdup(buffer);
};

Construction_es_def::Construction_es_def(Surface_es_def* aLeftSurface_def,
		       Surface_es_def* aRightSurface_def,
		       List(Layer_es_def)& lyr_defs,	// deep copy
		       char* arightZoneName, char* aleftZoneName,
		       char* a_conduction_name)
				: Construction_basic_def(
					   (Surface_basic_def*) aLeftSurface_def,
					   (Surface_basic_def*) aRightSurface_def,
					   (List(Layer_basic_def)&) lyr_defs,
					   arightZoneName, aleftZoneName )
{
	DEBUG	<< Construction_es_def::Construction_es_def(Surface_es_def* a_leftSurface_def,\n";
	DEBUG	<< "List(Layer_def)& lyr_defs, Surface_es_def* a_rightSurface_def,\n"
	DEBUG	<<  "char* arightZoneName, char* aleftZoneName)\n";

	name(class_name);
	directType(TYPE_OF(Construction_es_def));

	the_conduction_name = a_conduction_name;
};

Construction_es_def::Construction_es_def(APL* theAPL)
						: Construction_basic_def(theAPL)
{};

Construction_es_def::~Construction_es_def()
{
	DEBUG << "Construction_es_def::~Construction_es_def()\n";
};


char*		Construction_es_def::conduction_name()
{
	DEBUG1	<< "char::Construction_es_def::conduction_name()\n";

	return the_conduction_name;
};


void	Construction_es_def::description(Metaclass* meta, ostream& s)
{
	Construction_basic_def::description(meta, s);
	s << indent << "conduction theory name for construction: \n";
};
