#ifndef CONSTRUCTION_ES_H
#define CONSTRUCTION_ES_H

// Construction_es.h
// @(#)Construction_es.h	1.1 3/17/91 (c) ESRU

#include	"transport/Equation_set.h"
#include	"building/Construction_basic.h"
#include	"building/Layer_es.h"
template_define(List,Layer_es);
class	Construction_es_def;
class	Surface_es;
class	Conduction;

extern	Type*	Construction_es_Type_pointer;

class Construction_es : public Construction_basic {
protected:
	Equation_set	the_equation_set;
	Conduction*	the_conduction;		// Conduction derivitive

	List_iterator(Layer_es)  myLayerIter();
public:
	Construction_es(Metaclass* meta, Construction_es_def* def);
	Construction_es(Construction_es& c);
	Construction_es(APL* theAPL);
	~Construction_es();

	void	Destroy(Boolean aborted);
	void	putObject(Boolean deallocate);
	void	deleteObject(Boolean deallocate);
	Type*	getDirectType();

	Construction_es& operator=(Construction_es& c);

        Conduction*		 conduction();
        Surface_es*		 leftSurface();
        Surface_es*		 rightSurface();
	List_iterator(Layer_es)  layer_iterator();
	Equation_iterator	 equation_iterator();	// NB can be empty

	void			 disc_conduction();
	void			 apply_boundary_conditions(Temperature& left,
							   Temperature& right);
};


inline
Type*	Construction_es::getDirectType()
{
	return TYPE_OF(Construction_es);
};

inline
Conduction*	Construction_es::conduction()
{
	return the_conduction;
}

inline
Surface_es*	Construction_es::leftSurface()
{						// cast guaranteed by Metaclass
	return (Surface_es*)theLeftSurface;
};

inline
Surface_es*	Construction_es::rightSurface()
{						// cast guaranteed by Metaclass
	return (Surface_es*)theRightSurface;
};

inline
List_iterator(Layer_es)	Construction_es::layer_iterator()
{						// cast guaranteed by Metaclass
	List_iterator(Layer_es) lst_iter((List(Layer_es)*)(&theLayers));
	return lst_iter;
};

inline
Equation_iterator	Construction_es::equation_iterator()
{
	DEBUG1 << "Equation_set*   Construction_es::equation_set()\n";

	Equation_iterator	iter(&the_equation_set);
	return iter;					// list may be empty 
}
#endif
