#include 	"building/Construction_es.h"

#include	"infrastructure/Metaclass.h"
#include	"transport/Equation_set.h"
#include	"building/Construction_es_def.h"
#include	"building/Surface_es.h"
#include	"building/Surface_es_def.h"
#include	"theory/Conduction.h"
#include	"theory/Conduction_def.h"

static	char*	class_name = "the_construction_es_xxx";
Type*	Construction_es_Type_pointer;


Construction_es::Construction_es(Metaclass* meta, Construction_es_def* def)
			: Construction_basic(meta, (Construction_basic_def*)def),
				  the_equation_set()
 { 
	DEBUG << "Construction_es::Construction_es(" << meta->oid() << ", " << def->oid() << ")\n";

	name(class_name);
	directType(TYPE_OF(Construction_es));
						// link to appropriate Conduction
	the_conduction = (Conduction*)metaclass->link_to("Conduction",
							 def->conduction_name() );
						// casts guaranteed by Metaclass
	Layer_es*	ll = (Layer_es *)theLayers.first();
	Layer_es*	lr = (Layer_es *)theLayers.last();
	leftSurface()->state_variable(ll->state_vector()->first());
	rightSurface()->state_variable(lr->state_vector()->last());
};

Construction_es::Construction_es(Construction_es& constr)
				: Construction_basic((Construction_basic&) constr),
				  the_equation_set(constr.the_equation_set)
{
	DEBUG << "Construction_es::Construction_es(" << constr->oid() << ")\n";

	name(class_name);
	directType(TYPE_OF(Construction_es));

	the_conduction = constr.conduction();
};

Construction_es::Construction_es(APL* theAPL) : Construction_basic(theAPL)
{
	RETRIEVE(the_conduction);
};

Construction_es::~Construction_es()
{
	DEBUG << "~Construction_es()\n";

	Destroy(FALSE);
};


void	Construction_es::Destroy(Boolean aborted)
{
	DEBUG << "Construction_es::Destroy(Boolean aborted)\n";

	if (aborted)
		Construction_basic::Destroy(aborted);
};

void	Construction_es::putObject(Boolean deallocate)
{
	DEBUG << "Construction_es::putObject(Boolean deallocate)\n";

	STORE(the_conduction);

	Construction_basic::putObject(deallocate);
};

void	Construction_es::deleteObject(Boolean deallocate)
{
	DEBUG << "Construction_es::deleteObject(Boolean deallocate)\n";

	Construction_basic::deleteObject(deallocate);
};


Construction_es& Construction_es::operator=(Construction_es& constr)
{
	DEBUG1 << "Construction_es::operator=(" << constr->oid() << ")\n";

	if(this==&constr) return (*this);

	(void) Construction_basic::operator=((Construction_basic&) constr);
	the_conduction = constr.conduction();
	the_equation_set = constr.the_equation_set;	// shallow copy

	return (*this);
};
 
void	Construction_es::disc_conduction()
{
	DEBUG1	<< "Layer_es::disc_conduction()\n";

// No need to re-evaluate time-invariant entries.
	if(the_equation_set.size() != 0)   return;
					// discretize 1st layer
	theLayerIter(RESET);
						// cast guaranteed by Metaclass
	Layer_es* layer = (Layer_es*)theLayerIter(FORWARD);
	layer->disc_conduction();
					//	... and get its eqns
	Equation_iterator	layer_eqn_iter(layer->equation_iterator());
	the_equation_set = layer_eqn_iter;
					// repeat for each remaining layers
	while (layer = (Layer_es*)theLayerIter(FORWARD)) {
		layer->disc_conduction();
		layer_eqn_iter = layer->equation_iterator();
					//	... adding to eqn set
		the_equation_set = conduction()->combine_equations(
					equation_iterator(),
					the_equation_set.last()->state_variable(),
					layer_eqn_iter,
					layer_eqn_iter[0]->state_variable(),
					this);
	};
					// propagate eqn sets to surfaces
	Equation_iterator	iter_left(&the_equation_set, AS_EQNS);
	leftSurface()->equation_iterator(iter_left);
	Equation_iterator	iter_right(&the_equation_set, REVERSE_EQNS);
	rightSurface()->equation_iterator(iter_right);

	DEBUG2	<< "got equation_set\n";
	DEBUG2	<< "Construction_es::equation_set =";
	DEBUG2	<< "\t" << the_equation_set;
};

	
void	Construction_es::apply_boundary_conditions(Temperature& left, Temperature& right)
{
	DEBUG1 << "Construction_es::apply_boundary_conditions(" << left << ", : << right << ")\n";

	leftSurface()->apply_boundary_conditions(left);
	rightSurface()->apply_boundary_conditions(right);
};



template_implement(List,Layer_es);
