#ifndef	CONSTRUCTION_BASIC_DEF_H
#define	CONSTRUCTION_BASIC_DEF_H

#include	"infrastructure/list.h"
#include	"building/Construction_def.h"
class	Layer_basic_def;
template_declare(List,Layer_basic_def);
class	Surface_def;
class	Surface_basic_def;

extern	Type*	Construction_basic_def_Type_pointer;


class Construction_basic_def : public Construction_def {
protected:
	List(Layer_basic_def)*	the_layer_defs;	    // Layer_basic_def or derived
  	Surface_basic_def*	theLeftSurface;	    // Surface_basic_def or derived
	Surface_basic_def*	theRightSurface;    // Surface_basic_def or derived
	char*		leftZoneName;
	char*		rightZoneName;
public:
	Construction_basic_def(Metaclass* meta);
	Construction_basic_def(Surface_basic_def* aLeftSurface_def,
		       Surface_basic_def* aRightSurface_def,
		       List(Layer_basic_def)* lyr_defs,		      // deep copy
		       char* arightZoneName, char* aleftZoneName);
	Construction_basic_def(APL* theAPL);
	~Construction_basic_def();

	void	Destroy(Boolean aborted);
	void	putObject(Boolean deallocate);
	void	deleteObject(Boolean deallocate);
	Type*	getDirectType();

	List_iterator(Layer_basic_def)	layer_def_iter();
	int				no_layers();
 	Surface_basic_def*		leftSurface_def();
	Surface_basic_def*		rightSurface_def();
	char*				right_zone_name();
	char*				left_zone_name();

static	void	description(Metaclass* meta, ostream& s);
};


inline
Type*	Construction_basic_def::getDirectType()
{
	return TYPE_OF(Construction_basic_def);
};
#endif
