#include	"Construction_basic_def.h"

#include	<string.h>
#include	<stdlib.h>
#include	"infrastructure/Metaclass.h"
#include	"building/Layer_basic_def.h"
template_define(List,Layer_basic_def);
#include	"building/Surface_basic_def.h"

static	char*	class_name = "the_construction_basic_def";
Type*	Construction_basic_def_Type_pointer;


Construction_basic_def::Construction_basic_def(Metaclass* meta)
					: Construction_def(meta)
{
	DEBUG	<< "Construction_basic_def::Construction_basic_def(" << meta->oid() << ")\n";

	name(class_name);
	directType(TYPE_OF(Construction_basic_def));


	cout << "Now define the layers in sequence:\n";
	Length	cur_thk = 0;
	int	no_layers = 0;
	the_layer_defs = new List(Layer_basic_def)();
	while (the_thickness != (Length)0  &&  cur_thk < the_thickness) {
		cout << "    Layer " << ++no_layers << "\n\t";
		Layer_basic_def* lyr_def = (Layer_basic_def*)meta->make_def_for("Layer");
		the_layer_defs->append(lyr_def);
					// X_def is at least an Layer_basic_def
		cur_thk += lyr_def->thickness();
	};

	if (the_thickness != (Length)0  &&  cur_thk != the_thickness) {
		cerr << "Construction_basic: sum of layer thicknesses > "
		     << "wall thickness\n	using layer values\n";
		cur_thk = the_thickness;
	};

	char	buffer[256];
	cout << "what zone is on the left (1st layer) of the construction? (zonename) ";
	cin >> buffer;
	leftZoneName = strdup(buffer);

	cout << "define the surface against the " << leftZoneName << "\n";
	theLeftSurface = (Surface_basic_def*)meta->make_def_for("Surface");

	cout << "what zone is on the right of the construction? ";
	cin >> buffer;
	rightZoneName = strdup(buffer);

	cout << "define the surface against the " << rightZoneName << "\n";
	theRightSurface = (Surface_basic_def*)meta->make_def_for("Surface");
};

Construction_basic_def::Construction_basic_def(Surface_basic_def* a_leftSurf_def,
					Surface_basic_def* a_rightSurf_def,
					List(Layer_basic_def)* lyr_defs,
					char* arightZoneName,
					char* aleftZoneName)
				: Construction_def((Length)0)
{
	DEBUG	<< Construction_basic_def::Construction_basic_def(Surface_def* a_leftSurf_def,\n";
	DEBUG	<< "List(Layer_basic_def)* lyr_defs, Surface_def* a_rightSurf_def,\n"
	DEBUG	<<  "char* arightZoneName, char* aleftZoneName)\n";

	name(class_name);
	directType(TYPE_OF(Construction_basic_def));

	List_iterator(Layer_basic_def)	def_iter(lyr_defs);
	Layer_basic_def*	ld;
	the_layer_defs = new List(Layer_basic_def)();
	while (ld = def_iter(FORWARD)) {
		Layer_basic_def* lyr_def = new Layer_basic_def(*ld);
		the_layer_defs->append(lyr_def);
		the_thickness += lyr_def->thickness();
	};

	theLeftSurface = a_leftSurf_def;
	theRightSurface = a_rightSurf_def;
	rightZoneName = arightZoneName;
	leftZoneName = aleftZoneName;
};

Construction_basic_def::Construction_basic_def(APL* theAPL)
					: Construction_def(theAPL)
{
	RETRIEVE(the_layer_defs);
	RETRIEVE(theRightSurface);
	RETRIEVE(theLeftSurface);
};

Construction_basic_def::~Construction_basic_def()
{
	DEBUG << "Construction_basic_def::~Construction_basic_def()\n";

	Destroy(FALSE);
};

void	Construction_basic_def::Destroy(Boolean aborted)
{
	DEBUG << "Construction_basic_def::Destroy(Boolean aborted)\n";

	DELETE(List(Layer_basic_def), the_layer_defs);
	DELETE(Surface_basic_def, theLeftSurface);
	DELETE(Surface_basic_def, theRightSurface);

	if (aborted)
		Construction_def::Destroy(aborted);
};

void	Construction_basic_def::putObject(Boolean deallocate)
{
	DEBUG << "Construction_basic_def::putObject(Boolean deallocate)\n";

	STORE(the_layer_defs);
	STORE(theRightSurface);
	STORE(theLeftSurface);

	Construction_def::putObject(deallocate);
};

void	Construction_basic_def::deleteObject(Boolean deallocate)
{
	DEBUG << "Construction_basic_def::deleteObject(Boolean deallocate)\n";

	FORGET(the_layer_defs);
	FORGET(theLeftSurface);
	FORGET(theRightSurface);

	Construction_def::deleteObject(deallocate);
};


List_iterator(Layer_basic_def)	Construction_basic_def::layer_def_iter()
{
	List_iterator(Layer_basic_def)	lst_iter(the_layer_defs);
	return lst_iter;
};

int	Construction_basic_def::no_layers()
{
	return	the_layer_defs->size();
};

Surface_basic_def*	Construction_basic_def::leftSurface_def()
{
	DEBUG1	<< "Surface_basic_def*   Construction_basic_def::leftSurface_def()\n";

	return (Surface_basic_def*)theLeftSurface;
};

Surface_basic_def*	Construction_basic_def::rightSurface_def()
{
	DEBUG1	<< "Surface_basic_def*   Construction_basic_def::rightSurface_def()\n";

	return (Surface_basic_def*)theRightSurface;
};

char*	Construction_basic_def::left_zone_name()
{
	DEBUG1	<< "Construction_basic_def::left_zone_name()\n";

	return leftZoneName;
};

char*	Construction_basic_def::right_zone_name()
{
	DEBUG1	<< "Construction_basic_def::right_zone_name()\n";

	return rightZoneName;
};


void	Construction_basic_def::description(Metaclass* meta, ostream& s)
{
	s << "Construction_basic\n";
	s << indent << "->  Layer  *n = \n";
	indent[strlen(indent)] = ' ';
	meta->describe_def_for("Layer", s);
	indent[strlen(indent-4)] = '\0';
	s << indent << "->  Surface  *2\n";
	strcat(indent,"    ");
	s << indent << "adj zone name: \n";
	s << indent << "           = ";
	meta->describe_def_for("Surface", s);
	indent[strlen(indent-4)] = '\0';
};



template_implement(List,Layer_basic_def);
