#ifndef CONSTRUCTION_BASIC_H
#define CONSTRUCTION_BASIC_H
 
#include	"infrastructure/list.h"
#include	"building/Layer_basic.h"
template_define(List,Layer_basic);
#include	"building/Surface_basic.h"
#include	"building/Construction.h"
#include	"building/Construction_basic_def.h"


enum	ConstructionOrder { REVERSED=-1, INVALIDSURFACE, ASGIVEN };

extern	Type*	Construction_basic_Type_pointer;


class Construction_basic : public Construction {
protected:
	List(Layer_basic)	theLayers;		// Layer_basic or derived
        Surface_basic*		theLeftSurface;		// Surface_basic or derived
        Surface_basic*		theRightSurface;	// Surface_basic or derived
							// an iter for internal use
	List_iterator(Layer_basic) theLayerIter;	// for internal use only
public:
	Construction_basic(Metaclass* meta, Construction_basic_def* def);
	Construction_basic(Construction_basic& c);	// shallow copy of layers
	Construction_basic(APL* theAPL);
	~Construction_basic();

	void	Destroy(Boolean aborted);
	void	putObject(Boolean deallocate);
	void	deleteObject(Boolean deallocate);
	Type*	getDirectType();

	Construction_basic& operator=(Construction_basic& constr);  // shallow copy
 
	List_iterator(Layer_basic)	layer_iterator();
	void				add_Layer(Layer_basic* lyr, Surface_basic* side);
	int				no_of_layers();
        Surface_basic*			leftSurface();
        Surface_basic*			rightSurface();
	ConstructionOrder		orderFromSurface(Surface_basic* s);

	virtual	ThermalResistance	thermal_resistance();
};


inline
Type*	Construction_basic::getDirectType()
{
	return TYPE_OF(Construction_basic);
};

inline
List_iterator(Layer_basic)	Construction_basic::layer_iterator()
{
	List_iterator(Layer_basic) lst_iter(&theLayers);
	return lst_iter;
};

inline
int Construction_basic::no_of_layers()
{
	return theLayers.size();
};

inline
Surface_basic*	Construction_basic::leftSurface()
{						// cast guaranteed by Metaclass
	return theLeftSurface;
};

inline
Surface_basic*	Construction_basic::rightSurface()
{						// cast guaranteed by Metaclass
	return theRightSurface;
};

inline
ConstructionOrder	Construction_basic::orderFromSurface(Surface_basic* s)
{
	if (s == theLeftSurface)
		return ASGIVEN;
	else if (s == theRightSurface)
		return REVERSED;
	else
		return INVALIDSURFACE;
};

#endif
