#include 	"building/Construction_basic.h"

#include	"dimensions/ThermalResistance.h"
#include	"infrastructure/Metaclass.h"
#include	"building/Layer_basic_def.h"
template_define(List,Layer_basic_def);
#include	"building/Surface_basic.h"
#include	"building/Surface_basic_def.h"

static	char*	class_name = "construction_basic_xxxxxx";
Type*	Construction_basic_Type_pointer;


Construction_basic::Construction_basic(Metaclass* meta, Construction_basic_def* def)
				: Construction(meta, (Construction_def*) def),
				  theLayers(), theLayerIter(&theLayers)
 { 
	DEBUG  << "Construction_basic::Construction_basic(" << meta->oid() << ", ";
	DEBUG  << def->oid() << ")\n";

	name(class_name);			//// should get name from def
	directType(TYPE_OF(Construction_basic));

	List_iterator(Layer_basic_def) index = def->layer_def_iter();
        Layer_basic_def* lyr_def;
        while(lyr_def=index(FORWARD)) {
		Layer_basic* layer = INSTANTIATE(Layer_basic,
							       lyr_def);
                theLayers.append(layer);
		the_thickness += lyr_def->thickness();
	};
						// make 2 Surface or derived
	theLeftSurface = INSTANTIATE(Surface_basic, def->leftSurface_def());
	theRightSurface = INSTANTIATE(Surface_basic, def->rightSurface_def());
};

Construction_basic::Construction_basic(Construction_basic& aConstruction)
				: Construction((Construction&) aConstruction.metaclass),
				  theLayers(), theLayerIter(&theLayers)
{ 
	DEBUG << "Construction_basic::Construction_basic(" << aConstruction->oid() << ")\n";

	directType(TYPE_OF(Construction_basic));

	aConstruction.theLayerIter(RESET);
	Layer_basic* layer;
	while(layer = aConstruction.theLayerIter(FORWARD))
		theLayers.append(layer);

	theLeftSurface = aConstruction.theLeftSurface;
	theRightSurface = aConstruction.theRightSurface;
};

Construction_basic::Construction_basic(APL* theAPL) : Construction(theAPL),
				  theLayers(theAPL), theLayerIter(&theLayers)
{
	RETRIEVE(theRightSurface);
	RETRIEVE(theLeftSurface);
};

Construction_basic::~Construction_basic()
{
	DEBUG << "~Construction_basic()\n";

	Destroy(FALSE);
};

void	Construction_basic::Destroy(Boolean aborted)
{
	DEBUG << "Construction_basic::Destroy(Boolean aborted)\n";

	theLayerIter(RESET);
	Layer_basic* layer;
	while (layer = theLayerIter(FORWARD))
		delete layer;		// ????? use Metaclass::destroy("Layer")

	DELETE(Surface_basic, theRightSurface);
	DELETE(Surface_basic, theLeftSurface);

	if (aborted)
		Construction::Destroy(aborted);
};

void	Construction_basic::putObject(Boolean deallocate)
{
	DEBUG << "Construction_basic::putObject(Boolean deallocate)\n";

	STORE(theRightSurface);
	STORE(theLeftSurface);

	Construction::putObject(deallocate);
};

void	Construction_basic::deleteObject(Boolean deallocate)
{
	DEBUG << "Construction_basic::deleteObject(Boolean deallocate)\n";

	FORGET(theLeftSurface);
	FORGET(theRightSurface);

	Construction::deleteObject(deallocate);
};

Construction_basic& Construction_basic::operator=(Construction_basic& constr)
{
	DEBUG1 << "Construction_basic::operator=(" << aConstruction->oid() << ")\n";

	if(this==&constr) return (*this);

	(void) Construction::operator=((Construction&) constr);

	theLayerIter(RESET);
	Layer_basic* layer;
	Layer_basic* lyr;
	while(lyr = theLayerIter(FORWARD))
		delete lyr;			// ????? use Metaclass::destroy
	theLayers.clear();
	constr.theLayerIter(RESET);
	while(layer = constr.theLayerIter(FORWARD))
		theLayers.append(layer);
	theLeftSurface = constr.theLeftSurface;
	theRightSurface = constr.theRightSurface;

	return (*this);
};
 

void	Construction_basic::add_Layer(Layer_basic* lyr, Surface_basic* side)
{
	DEBUG1 << "void	Construction::add_Layer(" << lyr->oid() << ", " << side->oid() << ")\n";

	if (side == theRightSurface)		//// (Surface*) casr necessary???
		theLayers.append(lyr);
	else
		theLayers.insert(lyr);
	the_thickness += lyr->thickness();
};

ThermalResistance	Construction_basic::thermal_resistance()
{
	DEBUG1 << "ThermalResistance Construction_basic::thermal_resistance()\n";

	ThermalResistance resistance_sum = 0;
	theLayerIter(RESET);
        Layer_basic* layer;
						// cast guaranteed by Metaclass
        while(layer = (Layer_basic*)theLayerIter(FORWARD))
		resistance_sum += layer->resistance();

	resistance_sum += leftSurface()->resistance() +
					  rightSurface()->resistance();

	return resistance_sum;
};


template_implement(List,Layer_basic);
