#include	"building/Building_es_sw.h"

#include	"theory/Shortwave_beam.h"
template_define(List,Shortwave_beam);

static	char*	class_name = "the_building_es_sw_xxxx";
Type*	Building_es_sw_Type_pointer;


Building_es_sw::Building_es_sw(Metaclass* meta, Building_es_sw_def* def)
			: Building_es(meta, (Building_es_def*)def),
			  the_equation_set(), draughts(),
			  rm_iter(contiguity.node_iterator())
{
	DEBUG	<< "Building_es_sw::Building_es_sw(" << meta->oid() << ", " << def->oid() << ")\n";

					// name is building name, from Building_def
	directType(TYPE_OF(Building_es_sw_es));

        theShortwave = (Shortwave*)metaclass->link_to("Shortwave",
							def->shortwave_name());
};

Building_es_sw::Building_es_sw(Building_es& bld)
				: Building_es((Building_es&) bld),
{
	DEBUG << "Building_es_sw::Building_es_sw(" << bld->oid() << ")\n";

	name(class_name);
	directType(TYPE_OF(Building_es_sw));

	theShortwave = bld.shortwave();
};

Building_es_sw::Building_es_sw(APL* theAPL) : Building_es(theAPL)
{
	RETRIEVE(theShortwave);
};

Building_es_sw::~Building_es_sw()
{
	DEBUG << "Building_es_sw::~Building_es_sw()\n";

	Destroy(FALSE);
};


void	Building_es_sw::Destroy(Boolean aborted)
{
	DEBUG << "Building_es_sw::Destroy(Boolean aborted)\n";

	if (aborted)
		Building_es::Destroy(aborted);
};

void	Building_es::putObject(Boolean deallocate)
{
	DEBUG << "Building_es_sw::putObject(Boolean deallocate)\n";

	STORE(theShortwave);

	Building_es::putObject(deallocate);
};

void	Building_es_sw::deleteObject(Boolean deallocate)
{
	DEBUG << "Building_es_sw::deleteObject(Boolean deallocate)\n";

	Building_es::deleteObject(deallocate);
};


Building_es_sw& Building_es_sw::operator=(Building_es_sw& bld)
{
	DEBUG1 << "Building_es_sw::operator=(" << bld->oid() << ")\n";

	if(this==&bld) return (*this);

	(void) Building_es::operator=((Building_es&) bld);
	theShortwave = bld.shortwave();

	return (*this);
};
 
void	Building_es_sw::apply_boundary_conditions(ClimateRegime* clm)
{
	DEBUG1 << "void	Building_es::apply_boundary_conditions(ClimateRegime* clm)\n";

				// insolation dealt with by Shortwave
	List(Shortwave_beam)	incident_list;
				// get list of external surfaces
	
	Room* outside = NULLPTR(Room);
	Network_iterator(Construction)	constr_iter =	// external constructions
				contiguity.arc_iterator(outside);
	Construction_basic*	constr;
	List(Surface) external_surfaces;
	while (constr = (Construction_basic*)constr_iter(FORWARD)) {
		if (contiguity.arc_source(constr, outside))
			external_surfaces.append(constr->leftSurface());
		else
			external_surfaces.append(constr->rightSurface());
	};

				// for each external surface
	List_iterator(Surface)  ex_surf_iter(&external_surfaces);
	Surface_es* surf_es;
	while(surf_es = (Surface_es*)ex_surf_iter(FORWARD)) {
		Equation_iterator surf_es_iter = surf_es->equation_iterator();
					// forced convection coupling.
		convection()->add_coupling(surf_es_iter,
					    surf_es_iter[0]->state_variable(),
					    surf_es,
					    surf_es_iter[0]->state_variable(),
/**???**/				    &this);
					// external longwave coupling.
		radiation()->add_coupling(surf_es_iter,
					  surf_es_iter[0]->state_variable(),
					  surf_es_iter,
					  surf_es_iter[0]->state_variable(),
/**???**/				  this);
					// collect shortwave radiation gains.
		Surface* surf = (Surface*)surf_es;
		Irradiance* a_beam = clm->irradiance_on(surf);
						// *** apply self shading
					// save in incident list
		Shortwave_beam* incident = new Shortwave_beam(a_beam, surf);
		incident_list.append(incident);
	};
				// now get buildings response to solar radiation
	theShortwave->building_response(incident_list, this);

				// infiltration gains.
	List(Room)&		rms = contiguity.neighbours(outside);
	List_iterator(Room)  	room_iter(&rms);
	Room_es* room;
	while(room = (Room_es*)room_iter(FORWARD)) {
		MassFlowRate infil = contiguity.connection(room, outside);
		if(infil != 0)   break;		// no mass flow
		flow_src = NULLPTR(RoomAirMass);
		flow_dst = room_es;
		flow_rate = infil;

////		Equation_iterator   src_rm_eqn_iter = NULLPTR(Equation_iterator);
		Equation_iterator   dst_rm_eqn_iter = room_es->equation_iterator();
				//??? how do we know which air nodes to use
				// assume only one air eqn
		(void) convection()->combine_equations(src_rm_eqn_iter,
////					NULLPTR(State_variable),
////					dst_rm_eqn_iter,
					dst_rm_eqn_iter[0]->state_variable(),
					this);
		Energy new_gain(new_coeff*ext_air_temp);
		(void) convection()->inject_energy(dst_rm_eqn_iter,
						   dst_rm_eqn_iter[0]->state_variable(),
						   new_gain);
	};
		
};



template_implement2(Network,MassFlowRate,RoomAirMass);
