#include	"building/Building_es_def.h"

#include	<string.h>
#include	"infrastructure/Metaclass.h"
template_define(List,Room_es_def);
template_define(List,Construction_es_def);


static	char*	class_name = "the building_es_def";
Type*	Building_es_def_Type_pointer;


Building_es_def::Building_es_def(Metaclass* meta)  : Building_basic_def(meta)
{
	DEBUG	<< "Building_es_def::Building_es_def(" << meta->oid() << ")\n";

					// name is building name (from Building)
	directType(TYPE_OF(Building_es_def));

	char	buffer[256];
	cout << "which Conduction theory object for building (name)? ";
	cin >> buffer;
	the_conduction_name = strdup(buffer);
	cout << "which Convection theory object for building (name)? ";
	cin >> buffer;
	the_convection_name = strdup(buffer);
	cout << "which Radiation theory object for building (name)? ";
	cin >> buffer;
	the_radiation_name = strdup(buffer);
};

Building_es_def::Building_es_def(char* a_name, List(Room_es_def)* room_defs,
				 List(Construction_es_def)* construction_defs)
		: Building_basic_def(a_name, (List(Room_def)*) room_defs,
			             (List(Construction_def)*) construction_defs) 
{
	DEBUG	<< "Building_es_def::Building_es_def(char* a_name, List(Room_es_def)* room_defs,\n";
	DEBUG	<< 			 List(Construction_es_def)* construction_defs)\n";

	directType(TYPE_OF(Building_es_def));

	the_conduction_name = a_conduction_name;
	the_convection_name = a_convection_name;
	the_radiation_name = a_radiation_name;
};

Building_es_def::Building_es_def(APL* theAPL)  : Building_basic_def(theAPL)
{};

Building_es_def::~Building_es_def()
{
	DEBUG << "Building_es_def::~Building_es_def()\n";
};


char*	Building_es_def::conduction_name()
{
	DEBUG1	<< "char*	Building_es_def::conduction_name()\n";

	return the_conduction_name;
};

char*	Building_es_def::convection_name()
{
	DEBUG1	<< "char*	Building_es_def::convection_name()\n";

	return the_convection_name;
};

char*	Building_es_def::radiation_name()
{
	DEBUG1	<< "char*	Building_es_def::radiation_name()\n";

	return the_radiation_name;
};

void    Building_es_def::description(Metaclass* meta, ostream& s)
{
	Building_basic_def::description(meta, s);
	s << indent << "conduction theory name for construction: \n";
	s << indent << "convection theory name for construction: \n";
	s << indent << "radiation theory name for construction: \n";
};




template_implement(List,Room_es_def);
template_implement(List,Construction_es_def);
