#ifndef BUILDING_ES_H
#define BUILDING_ES_H

/* comment */

#include	"transport/Equation_set.h"
#include	"building/Building_basic.h"
//???class	MassFlowRate;
typedef	double	MassFlowRate;
typedef	Room	RoomAirMass;
template_define2(Network,MassFlowRate,RoomAirMass);
class	Building_es_def;
class	Room_es;
class   State_vector;
class   Conduction;
class   Convection;
class   Radiation;
class	AirVolume;
class	ClimateRegime;

extern	Type*	Building_es_Type_pointer;


class Building_es : public Building {
protected:
        Equation_set		the_equation_set;
	Conduction*		theConduction;
	Convection*		theConvection;
	Radiation*		theRadiation;

	Network(MassFlowRate,RoomAirMass)	draughts;
	Network_iterator(Room)	rm_iter;

	RoomAirMass*	flow_src;			// tmps for communication
	RoomAirMass*	flow_dst;			//    between disc_convect
	MassFlowRate	flow_rate;			//    and massFlow_between
public:
	Building_es(Metaclass* meta, Building_es_def* def);
	Building_es(Building_basic& bld);
	Building_es(APL* theAPL);
	~Building_es();

	void	Destroy(Boolean aborted);
	void	putObject(Boolean deallocate);
	void	deleteObject(Boolean deallocate);
	Type*	getDirectType();

	Building_es&	operator=(Building_es& c);

	Conduction*		conduction();
	Convection*		convection();
	Radiation*		radiation();		// external rad
        Shortwave*		shortwave();
        Equation_iterator	equation_iterator();    // NB can be NULL
	MassFlowRate*		massFlowRate_between(AirVolume* av1, AirVolume* av2);

	void			thermal_disc();
        void			disc_conduction();
	void			disc_convection();
	void			disc_contents();
	void			disc_longwave();
	void			disc_heatsources();
	void			apply_boundary_conditions(ClimateRegime* clm);

	List(Shortwave_beam)&	shortwave_response(List(Shortwave_beam)& incident);
};


Type*	Building_es::getDirectType()
{
	return TYPE_OF(Building_es);
};

inline
Conduction*     Building_es::conduction()
{        return (Conduction*)theConduction;
}

inline
Convection*     Building_es::convection()
{
        return (Convection*)theConvection;
}

inline
Radiation*     Building_es::radiation()
{
        return (Radiation*)theRadiation;
}

inline
Equation_iterator     Building_es::equation_iterator()
{
        Equation_iterator       iter(&the_equation_set);
        return iter;        				// list may be empty 
};

#endif
