#include	"building/Building_es.h"

#include	"infrastructure/Metaclass.h"
#include	"transport/ClimateRegime.h"
#include	"building/Building_es_def.h"
#include	"building/Room_es.h"
#include	"building/Construction_basic.h"
#include	"building/Surface_es.h"
template_define(List,Construction);
//???#include	"MassFlowRate.h"
#include	"theory/Convection.h"
#include	"theory/Radiation.h"

static	char*	class_name = "the_building_es_xxxx";
Type*	Building_es_Type_pointer;


Building_es::Building_es(Metaclass* meta, Building_es_def* def)
			: Building_basic(meta, (Building_basic_def*)def),
			  the_equation_set(), draughts(),
			  rm_iter(contiguity.node_iterator())
{
	DEBUG	<< "Building_es::Building_es(" << meta->oid() << ", " << def->oid() << ")\n";

					// name is building name, from Building_def
	directType(TYPE_OF(Building_es));

        theConduction = (Conduction*)metaclass->link_to("Conduction",
							def->conduction_name());
        theConvection = (Convection*)metaclass->link_to("Convection",
							def->convection_name());
        theRadiation = (Radiation*)metaclass->link_to("Radiation",
							def->radiation_name());
};

Building_es::Building_es(Building_es& bld)
				: Building_basic((Building_basic&) bld),
				  the_equation_set(bld.the_equation_set)
{
	DEBUG << "Building_es::Building_es(" << bld->oid() << ")\n";

	name(class_name);
	directType(TYPE_OF(Building_es));

	theConduction = bld.conduction();
	theConvection = bld.convection();
	theRadiation = bld.radiation();
};

Building_es::Building_es(APL* theAPL) : Building_basic(theAPL)
{
	RETRIEVE(theConduction);
	RETRIEVE(theConvection);
	RETRIEVE(theRadiation);
};

Building_es::~Building_es()
{
	DEBUG << "Building_es::~Building_es()\n";

	Destroy(FALSE);
};


void	Building_es::Destroy(Boolean aborted)
{
	DEBUG << "Building_es::Destroy(Boolean aborted)\n";

	if (aborted)
		Building_basic::Destroy(aborted);
};

void	Building_es::putObject(Boolean deallocate)
{
	DEBUG << "Building_es::putObject(Boolean deallocate)\n";

	STORE(theConduction);
	STORE(theConvection);
	STORE(theRadiation);

	Building_basic::putObject(deallocate);
};

void	Building_es::deleteObject(Boolean deallocate)
{
	DEBUG << "Building_es::deleteObject(Boolean deallocate)\n";

	Building_basic::deleteObject(deallocate);
};


Building_es& Building_es::operator=(Building_es& bld)
{
	DEBUG1 << "Building_es::operator=(" << bld->oid() << ")\n";

	if(this==&bld) return (*this);

	(void) Building_basic::operator=((Building_basic&) bld);
	theConduction = bld.conduction();
	theConvection = bld.convection();
	theRadiation = bld.radiation();
	the_equation_set = bld.the_equation_set;	// shallow copy

	return (*this);
};
 
//???	NB, Building has to know Rooms have Airvolumes (encapsulation! whats that?)
MassFlowRate*	Building_es::massFlowRate_between(AirVolume* av1,
						  AirVolume* av2)
{
	DEBUG1	<< "MassFlowRate	Building_es::massFlowRate_between(AirVolume* av1,\n";
	DEBUG1	<< "			AirVolume* av2)\n";
					// check tmps in case we're doing a inter-
					// room conv calc for disc_convection()
	if ((av1 == (AirVolume*)flow_src->airVolume())  &&
	    (av2 == (AirVolume*)flow_dst->airVolume()))
		return &flow_rate;
					// Search each draught for the sv1
	Network_iterator(MassFlowRate)& conn_iter =
					draughts.arc_iterator();
	MassFlowRate*	conn;
	while (conn = conn_iter(FORWARD))
		if ((av1 == draughts.arc_source(conn)->airVolume())  &&
		    (av2 == draughts.arc_target(conn)->airVolume()))
			return conn;
	return NULLPTR(MassFlowRate);
};


void	Building_es::thermal_disc()
{
	DEBUG1 << "void	Building_es::thermal_disc()\n";

				// generate eqns for building fabric
				//    (room contents handled separately)
	disc_conduction();
	disc_convection();
					// correct eqns for ...
	disc_contents();		//  ...	contents (+ extra eqns)
	disc_longwave();		//  ...	longwave exchange
	disc_heatsources();		//  ...	gains from people, etc
				// now collect the equations
				//	for all constrs
	List(Construction)& rmlnkr_lst = contiguity.arcs();
	List_iterator(Construction) rmlnkr_iter(&rmlnkr_lst);
	Construction_es*	constr;
						// cast guaranteed by Metaclass
	while (constr = (Construction_es*)rmlnkr_iter(FORWARD))
		the_equation_set += constr->equation_iterator();
				//	and for all rooms
	rm_iter(RESET);
	Room_es*	rm;
						// cast guaranteed by Metaclass
	while (rm = (Room_es*)rm_iter(FORWARD))
		the_equation_set += rm->equation_iterator();
	delete &rmlnkr_lst;
};

void	Building_es::disc_conduction()
{
	DEBUG1 << "void	Building_es::disc_conduction()\n";

				// generate conduction eqns for constructions
	List(Construction)& rmlnkr_lst = contiguity.arcs();
	List_iterator(Construction) rmlnkr_iter(&rmlnkr_lst);
	Construction_es*	constr;
						// cast guaranteed by Metaclass
	while (constr = (Construction_es*)rmlnkr_iter(FORWARD))
		constr->disc_conduction();
	delete &rmlnkr_lst;
};

void	Building_es::disc_convection()
{
	DEBUG1 << "void	Building_es::disc_convection()\n";

				// generate convection eqns for air masses
	rm_iter(RESET);
	Room_es*	rm;
						// cast guaranteed by Metaclass
	while (rm = (Room_es*)rm_iter(FORWARD)) 
		rm->disc_convection();
				// fixup for inter rooom convection
	Network_iterator(MassFlowRate)& conn_iter =
					draughts.arc_iterator();
	MassFlowRate*	conn;
	while (conn = conn_iter(FORWARD)) {
					// set up tmps for callback to MFbetween()
		if (*conn == 0.0)   break;	// no air flow
		flow_src = draughts.arc_source(conn);
		flow_dst = draughts.arc_target(conn);
		if (flow_src == NULLPTR(Room)  ||  flow_dst == NULLPTR(Room))
			break;			// infiltration handled separately
		flow_rate = *conn;

						// cast guaranteed by Metaclass
		Equation_iterator	src_rm_eqn_iter = ((Room_es*)flow_src)->equation_iterator();
		Equation_iterator	dst_rm_eqn_iter = ((Room_es*)flow_dst)->equation_iterator();
				//??? how do we know which air nodes to use
				// assume only one air eqn
		(void) convection()->combine_equations(src_rm_eqn_iter,
					src_rm_eqn_iter[0]->state_variable(),
					dst_rm_eqn_iter,
					dst_rm_eqn_iter[0]->state_variable(),
					this);
	};
};

void	Building_es::disc_longwave()
{
	DEBUG1 << "void	Building_es::disc_longwave()\n";

				// generate longwave exchange eqns for surfaces
	rm_iter(RESET);
	Room_es*	rm;
						// cast guaranteed by Metaclass
	while (rm = (Room_es*)rm_iter(FORWARD)) {
		rm->disc_longwave();	//  ...	longwave exchange
	};
};

void	Building_es::disc_contents()
{
	DEBUG1 << "void	Building_es::disc_contents()\n";

				// generate eqns & gains for room contents
	rm_iter(RESET);
	Room_es*	rm;
						// cast guaranteed by Metaclass
	while (rm = (Room_es*)rm_iter(FORWARD)) {
		rm->disc_contents();
	};
};

void	Building_es::disc_heatsources()
{
	DEBUG1 << "void	Building_es::disc_heatsources()\n";

					//  generate gains from people, etc
	rm_iter(RESET);
	Room_es*	rm;
						// cast guaranteed by Metaclass
	while (rm = (Room_es*)rm_iter(FORWARD)) {
		rm->disc_heatsources();
	};
};


void	Building_es::apply_boundary_conditions(ClimateRegime* clm)
{
	DEBUG1 << "void	Building_es::apply_boundary_conditions(ClimateRegime* clm)\n";

				// get list of external surfaces
	
	Room* outside = NULLPTR(Room);
	Network_iterator(Construction)	constr_iter =	// external constructions
				contiguity.arc_iterator(outside);
	Construction_basic*	constr;
	List(Surface) external_surfaces;
	while (constr = (Construction_basic*)constr_iter(FORWARD)) {
		if (contiguity.arc_source(constr, outside))
			external_surfaces.append(constr->leftSurface());
		else
			external_surfaces.append(constr->rightSurface());
	};

				// for each external surface
	List_iterator(Surface)  ex_surf_iter(&external_surfaces);
	Surface_es* surf_es;
	while(surf_es = (Surface_es*)ex_surf_iter(FORWARD)) {
		Equation_iterator surf_es_iter = surf_es->equation_iterator();
					// forced convection coupling.
		convection()->add_coupling(surf_es_iter,
					    surf_es_iter[0]->state_variable(),
					    surf_es,
					    surf_es_iter[0]->state_variable(),
/**???**/				    &this);
					// external longwave coupling.
		radiation()->add_coupling(surf_es_iter,
					  surf_es_iter[0]->state_variable(),
					  surf_es_iter,
					  surf_es_iter[0]->state_variable(),
/**???**/				  this);
	};

				// infiltration gains.
	List(Room)&		rms = contiguity.neighbours(outside);
	List_iterator(Room)  	room_iter(&rms);
	Room_es* room;
	while(room = (Room_es*)room_iter(FORWARD)) {
		MassFlowRate infil = contiguity.connection(room, outside);
		if(infil != 0)   break;		// no mass flow
		flow_src = NULLPTR(RoomAirMass);
		flow_dst = room_es;
		flow_rate = infil;

////		Equation_iterator   src_rm_eqn_iter = NULLPTR(Equation_iterator);
		Equation_iterator   dst_rm_eqn_iter = room_es->equation_iterator();
				//??? how do we know which air nodes to use
				// assume only one air eqn
		(void) convection()->combine_equations(src_rm_eqn_iter,
////					NULLPTR(State_variable),
////					dst_rm_eqn_iter,
					dst_rm_eqn_iter[0]->state_variable(),
					this);
		Energy new_gain(new_coeff*ext_air_temp);
		(void) convection()->inject_energy(dst_rm_eqn_iter,
						   dst_rm_eqn_iter[0]->state_variable(),
						   new_gain);
	};
		
};



template_implement2(Network,MassFlowRate,RoomAirMass);
