#include	"Building_def.h"

#include	<string.h>
#include	<stdlib.h>
#include	"Metaclass.h"

template_define(List,Room_def)
template_define(List,Construction_def)

static	char*	class_name = "the building_def";
static	char*	class_type = "Building_def";


Building_def::Building_def(Metaclass* meta)  : (meta)
{
	DEBUG	<< "Building_def::Building_def(" << meta->oid() << ")\n";

/**/	my_type = class_type;

	char	buffer[256];
	cout << "What do you call this building? ";
	cin >> buffer;

	my_name = strdup(buffer);
/**/	my_type = class_type;

	int	no_rooms;
	cout << "haw many rooms? ";
	cin >> no_rooms;
	the_rooms = new List(Room_def);
	for (int i = 0; i < no_rooms; i++) {
		cout << "define room " << i+1 << "\n";
		Room_def* room_def = (Room_def*)meta->make_def_for("Room");
		the_rooms->append(room_def);
	};

	int	no_constructions;
	cout << "haw many constructions? ";
	cin >> no_constructions;
	the_constructions = new List(Construction_def);
	for (i = 0; i < no_constructions; i++) {
		cout << "define construction " << i+1 << "\n";
		Construction_def* construction_def = (Construction_def*)meta->make_def_for("Construction");
		the_constructions->append(construction_def);
	};
};

Building_def::Building_def(char* a_name, List(Room_def)* room_defs,
					 List(Construction_def)* construction_defs)
			: (NULLPTR(Metaclass)) 
{
	DEBUG	<< "Building_def::Building_def(char* a_name, List(Room_def)* room_defs,\n";
	DEBUG	<< 			 List(Construction_def)* construction_defs)\n";

	my_type = class_type;

	my_name = strdup(a_name);

	the_rooms = room_defs;
	the_constructions = construction_defs;
};

Building_def::~Building_def()
{
	DEBUG << "Building_def::~Building_def()\n";
};


List_iterator(Room_def)	Building_def::room_def_iter()
{
	DEBUG1	<< "Building_def::room_def_iter_def()\n";

	return *new List_iterator(Room_def)(the_rooms);
};

List_iterator(Construction_def)	Building_def::construction_def_iter()
{
	DEBUG1	<< "Building_def::construction_def_iter_def()\n";

	return *new List_iterator(Construction_def)(the_constructions);
};


void    Building_def::description(Metaclass* meta, ostream& s)
{
        s << "building name: \n";
	s << "no rooms: \n-> *n  Room\n";
        meta->describe_def_for("Room", s);
	s << "<-     Room\n";
	s << "no constructions:\n-> *n  Construction\n";
        meta->describe_def_for("Construction", s);
	s << "<-     Construction\n";
};




template_implement(List,Room_def);
template_implement(List,Construction_def);
