#ifndef	BUILDING_BASIC_DEF_H
#define	BUILDING_BASIC_DEF_H


#include	"infrastructure/list.h"
#include	"building/Building_def.h"
class	Metaclass;
class	Room_def;
class	Construction_def;
template_declare(List,Room_def);
template_declare(List,Construction_def);

extern	Type*	Building_basic_def_Type_pointer;


class	Building_basic_def : public Building_def {
	List(Room_def)*		the_rooms;
	List(Construction_def)*	the_constructions;

	void*			the_contiguity;	    // Network(Construction,Room)*
public:
	Building_basic_def(Metaclass* meta);
	Building_basic_def(char* a_name, List(Room_def)* room_defs,
				       List(Construction_def)* construction_defs);
	Building_basic_def(APL* theAPL);
	~Building_basic_def();

	void	Destroy(Boolean aborted);
	void	putObject(Boolean deallocate);
	void	deleteObject(Boolean deallocate);
	Type*	getDirectType();

	void		contiguity(void* network);
	void*		contiguity();

	List_iterator(Room_def)		room_def_iter();
	List_iterator(Construction_def)	construction_def_iter();

static  void    description(Metaclass* meta, ostream& s);
};


inline
Type*	Building_basic_def::getDirectType()
{
	return TYPE_OF(Building_basic_def);
};

inline
void*	Building_basic_def::contiguity()
{
	return the_contiguity;
};

#endif
