#include	"building/Building_basic_def.h"

#include	<string.h>
#include	<stdlib.h>
#include	"infrastructure/Metaclass.h"
#include	"building/Building_def.h"
#include	"building/Room_def.h"
template_define(List,Room_def);
template_define(List,Construction_def);

static	char*	class_name = "the building_basic_def";
Type*	Building_basic_def_Type_pointer;


Building_basic_def::Building_basic_def(Metaclass* meta)
					: Building_def(meta)
{
	DEBUG	<< "Building_basic_def::Building_basic_def(" << meta->oid() << ")\n";

	directType(TYPE_OF(Building_basic_def));

	int	no_rooms;
	cout << "haw many rooms? ";
	cin >> no_rooms;
	theVolume = 0.0;
	the_rooms = new List(Room_def)();
	for (int i = 0; i < no_rooms; i++) {
		cout << "define room " << i+1 << "\n";
		Room_def* room_def = (Room_def*)meta->make_def_for("Room");
		the_rooms->append(room_def);
		theVolume += room_def->volume();
	};

	int	no_constructions;
	cout << "haw many constructions? ";
	cin >> no_constructions;
	the_constructions = new List(Construction_def)();
	for (i = 0; i < no_constructions; i++) {
		cout << "define construction " << i+1 << "\n";
		Construction_def* construction_def = (Construction_def*)meta->make_def_for("Construction");
		the_constructions->append(construction_def);
	};
};

Building_basic_def::Building_basic_def(char* a_name, List(Room_def)* room_defs,
				       List(Construction_def)* construction_defs)
			: Building_def(a_name, 0.0)
{
	DEBUG	<< "Building_basic_def::Building_basic_def(char* a_name, List(Room_def)* room_defs,\n";
	DEBUG	<< 			 List(Construction_def)* construction_defs)\n";

	name(strdup(a_name));
	directType(TYPE_OF(Building_def));


	the_rooms = new List(Room_def)(*room_defs);
	the_constructions = new List(Construction_def)(*construction_defs);
};

Building_basic_def::Building_basic_def(APL* theAPL)  : Building_def(theAPL)
{
	RETRIEVE(the_rooms);
	RETRIEVE(the_constructions);
};

Building_basic_def::~Building_basic_def()
{
	DEBUG << "Building_basic_def::~Building_basic_def()\n";

	Destroy(FALSE);
};


void	Building_basic_def::Destroy(Boolean aborted)
{
	DEBUG << "Building_basic_def::Destroy(Boolean aborted)\n";

	DELETE(List(Room_def), the_rooms);
	DELETE(List(Construction_def), the_constructions);

	if (aborted)
		Building_def::Destroy(aborted);
};

void	Building_basic_def::putObject(Boolean deallocate)
{
	DEBUG << "Building_basic_def::putObject(Boolean deallocate)\n";

	STORE(the_rooms);
	STORE(the_constructions);

	Building_def::putObject(deallocate);
};

void	Building_basic_def::deleteObject(Boolean deallocate)
{
	DEBUG << "Building_basic_def::deleteObject(Boolean deallocate)\n";

	FORGET(the_rooms);
	FORGET(the_constructions);

	Building_def::deleteObject(deallocate);
};


List_iterator(Room_def)	Building_basic_def::room_def_iter()
{
	DEBUG1	<< "Building_basic_def::room_def_iter_def()\n";

	return *new List_iterator(Room_def)(the_rooms);
};

List_iterator(Construction_def)	Building_basic_def::construction_def_iter()
{
	DEBUG1	<< "Building_basic_def::construction_def_iter_def()\n";

	return *new List_iterator(Construction_def)(the_constructions);
};


void    Building_basic_def::description(Metaclass* meta, ostream& s)
{
	s << "Building\n";
        s << indent << "building name: \n";
	s << indent << "no rooms: \n";
	s << indent << "-> *n  Room = ";
	indent[strlen(indent)] = ' ';
        meta->describe_def_for("Room", s);
	indent[strlen(indent) - 4] = '\0';
	s << indent << "no constructions:\n";
	s << indent << "-> *n  Construction\n";
	indent[strlen(indent)] = ' ';
        meta->describe_def_for("Construction", s);
	indent[strlen(indent) - 4] = '\0';
};




template_implement(List,Room_def);
template_implement(List,Construction_def);
