#ifndef BUILDING_BASIC_H
#define BUILDING_BASIC_H

#include	"infrastructure/network.h"
#include	"building/Building.h"
class	Building_basic_def;
class	Room;
class	Construction;
template_declare(List,Construction);
template_declare(List,Room);
template_declare2(Network,Construction,Room);
class	Surface;
template_declare(List,Surface);

extern	Type*	Building_basic_Type_pointer;
				

class Building_basic : public Building {
protected:
	Network(Construction,Room)*	contiguity;

	Room*	findzone(char* room_name);
public:
	Building_basic(Metaclass* meta, Building_basic_def* def);
	Building_basic(APL* theAPL);
	~Building_basic();

	void	Destroy(Boolean aborted);
	void	putObject(Boolean deallocate);
	void	deleteObject(Boolean deallocate);
	Type*	getDirectType();

	List(Room)		rooms();
	List(Construction)	constructions();
	List(Construction)	constructions_for(Room* rm);
	List(Surface)		surfaces_for(Room* rm);
	Room*			leftRoom_for(Construction* constr);
	Room*			rightRoom_for(Construction* constr);

};
 

inline
Type*	Building_basic::getDirectType()
{
	return TYPE_OF(Building_basic);
};
#endif
