#include	"building/Building_basic.h"

#include	<string.h>
#include	"infrastructure/Metaclass.h"
#include	"building/Building_basic_def.h"
#include	"building/Room.h"
template_define(List,Room);
#include	"building/Construction_basic.h"
template_define(List,Construction);
template_define2(Network,Construction,Room);
#include	"building/Room_def.h"
template_define(List,Room_def);
#include	"Construction_basic_def.h"
template_define(List,Construction_def);
template_define(List,Surface);

Type*	Building_basic_Type_pointer;


Room*	Building_basic::findzone(char* room_name)
{
	Network_iterator(Room) rm_iter = contiguity->node_iterator();
	Room* node;
	while (node = rm_iter(FORWARD))
		if (!strcmp(node->name(),room_name))
			break;

	return node;
};

Building_basic::Building_basic(Metaclass* meta, Building_basic_def* def)
				: Building(meta, (Building_def*) def)
{
	DEBUG	<< "Building_basic::Building_basic(" << meta->oid() << ", " << def->oid() << ")\n";

					// name is building name, from Building_def
        directType(TYPE_OF(Building_basic));

			// make the rooms and add to contiguity
			//     save Room* for use when defining constructions

	theVolume = 0.0;
	contiguity = new Network(Construction,Room)();
	List_iterator(Room_def) rm_index = def->room_def_iter();
        Room_def* room_def;
        while(room_def = rm_index(FORWARD)) {
				// add pointer to self to x_def
		room_def->caller(this);
		Room* room = INSTANTIATE(Room, room_def);
		contiguity->add_node(room);
		theVolume += room_def->volume();
	};
			// make the constructions
	List_iterator(Construction_def) rmlnk_index = def->construction_def_iter();
        Construction_basic_def* construction_def;
						// cast guaranteed by Metaclass
        while(construction_def = (Construction_basic_def*)rmlnk_index(FORWARD)) {
		Construction* construction = INSTANTIATE(Construction,
							 construction_def);
		Room* right_room = findzone(construction_def->right_zone_name());
		Room* left_room = findzone(construction_def->left_zone_name());
		contiguity->add_arc(construction, right_room, left_room);
	};
};

Building_basic::Building_basic(APL* theAPL) : Building(theAPL)
{
	RETRIEVE(contiguity);
};

Building_basic::~Building_basic()
{
	DEBUG << "Building_basic::~Building_basic()\n";

	Destroy(FALSE);
};

void	Building_basic::Destroy(Boolean aborted)
{
	DEBUG << "Building::Destroy(Boolean aborted)\n";


	Network_iterator(Room) rm_iter = contiguity->node_iterator();
	Room* node;
	while (node = rm_iter(FORWARD))
		delete node;

	Network_iterator(Construction) rmlnk_iter = contiguity->arc_iterator();
	Construction_basic* arc;
						// cast guarranteed by Metaclass
	while (arc = (Construction_basic*)rmlnk_iter(FORWARD))
		delete arc;

	DELETE(Network(Construction,Room), contiguity);

	if(aborted)
		Building::Destroy(aborted);
};

void	Building_basic::putObject(Boolean deallocate)
{
	STORE(contiguity);
};

void	Building_basic::deleteObject(Boolean deallocate)
{
	FORGET(contiguity);
};


List(Room)	Building_basic::rooms()
{
	DEBUG << "List(Room)	Building_basic::rooms()\n";

	return contiguity->nodes();
};

List(Construction)	Building_basic::constructions()
{
	DEBUG << "List(Construction)	Building_basic::constructions()\n";

	return contiguity->arcs();
};

List(Construction)	Building_basic::constructions_for(Room* rm)
{
	DEBUG << "List(Construction)	Building_basic::constructions_for(Room* rm)\n";

	return contiguity->connections(rm);
};

List(Surface)	Building_basic::surfaces_for(Room* rm)
{
	DEBUG << "List(Surface)   Building_basic::surfaces_for(Room* rm)\n";

	List(Surface)	surf_lst;
	Network_iterator(Construction)	constr_iter =  contiguity->arc_iterator(rm);

	Construction_basic*	constr;
						// cast guaranteed by Metaclass
	while (constr = (Construction_basic*)constr_iter(FORWARD))
		if (contiguity->arc_source(constr, rm))
			surf_lst.append((Surface*)constr->leftSurface());
		else
			surf_lst.append((Surface*)constr->rightSurface());
	
	return surf_lst;
};

Room*	Building_basic::leftRoom_for(Construction* constr)
{
	DEBUG << "Room*   Building_basic::leftRoom_for(Construction* constr)\n";

	return contiguity->arc_source(constr);
};

Room*	Building_basic::rightRoom_for(Construction* constr)
{
	DEBUG << "Room*   Building_basic::rightRoom_for(Construction* constr)\n";

	return contiguity->arc_target(constr);
};



template_implement(List,Surface);
template_implement(List,Construction);
template_implement2(Network,Construction,Room);
