#include	"Building.h"

#include	<string.h>
#include	"Building_def.h"
#include	"Metaclass.h"
#include	"Room.h"
template_define(List,Room);
#include	"Construction_basic.h"
template_define(List,Construction);
#include	"Room_def.h"
template_define(List,Room_def);
#include	"Construction_basic_def.h"
template_define(List,Construction_def);
class	Surface_basic;

static	char*	class_name = "the_building";
/**/static	char*	class_type = "Building";


Room*	Building::findzone(char* room_name)
{
	Network_iterator(Room) rm_iter = contiguity.node_iterator();
	Room* node;
	while (node = rm_iter(FORWARD))
		if (!strcmp(node->name(),room_name))
			break;

	return node;
};

Building::Building(Metaclass* meta, Building_def* def)
				: (meta), contiguity()
{
	DEBUG	<< "Building::Building(" << meta->oid() << ", " << def->oid() << ")\n";

	name(def->name());
/**/	my_type = class_type;

			// make the rooms and add to contiguity
			//     save Room* for use when defining constructions
	List_iterator(Room_def) rm_index = def->room_def_iter();
        Room_def* room_def;
        while(room_def = rm_index(FORWARD)) {
				// add pointer to self to x_def
		room_def->caller(this);
		Room* room = (Room*)metaclass->make_a("Room", room_def);
		contiguity.add_node(room);
	};
			// make the constructions
	List_iterator(Construction_def) rmlnk_index = def->construction_def_iter();
        Construction_basic_def* construction_def;
						// cast guaranteed by Metaclass
        while(construction_def = (Construction_basic_def*)rmlnk_index(FORWARD)) {
		Construction* construction = (Construction*)metaclass->make_a("Construction", construction_def);
		Room* right_room = findzone(construction_def->right_zone_name());
		Room* left_room = findzone(construction_def->left_zone_name());
		contiguity.add_arc(construction, right_room, left_room);
	};
};

Building::~Building()
{
	DEBUG << "Building::~Building()\n";

	Network_iterator(Room) rm_iter = contiguity.node_iterator();
	Room* node;
	while (node = rm_iter(FORWARD))
		delete node;

	Network_iterator(Construction) rmlnk_iter = contiguity.arc_iterator();
	Construction_basic* arc;
						// cast guarranteed by Metaclass
	while (arc = (Construction_basic*)rmlnk_iter(FORWARD))
		delete arc;
};


List(Room)	Building::rooms()
{
	DEBUG << "List(Room)	Building::rooms()\n";

	return contiguity.nodes();
};

List(Construction)	Building::constructions()
{
	DEBUG << "List(Construction)	Building::constructions()\n";

	return contiguity.arcs();
};

List(Construction)	Building::constructions_for(Room* rm)
{
	DEBUG << "List(Construction)	Building::constructions_for(Room* rm)\n";

	return contiguity.connections(rm);
};

List(Surface)	Building::surfaces_for(Room* rm)
{
	DEBUG << "List(Surface)   Building::surfaces_for(Room* rm)\n";

	List(Surface)	surf_lst;
	Network_iterator(Construction)	constr_iter =  contiguity.arc_iterator(rm);

	Construction_basic*	constr;
						// cast guaranteed by Metaclass
	while (constr = (Construction_basic*)constr_iter(FORWARD))
		if (contiguity.arc_source(constr, rm))
			surf_lst.append((Surface*)constr->leftSurface());
		else
			surf_lst.append((Surface*)constr->rightSurface());
	
	return surf_lst;
};

Room*	Building::leftRoom_for(Construction* constr)
{
	DEBUG << "Room*   Building::leftRoom_for(Construction* constr)\n";

	return contiguity.arc_source(constr);
};

Room*	Building::rightRoom_for(Construction* constr)
{
	DEBUG << "Room*   Building::rightRoom_for(Construction* constr)\n";

	return contiguity.arc_target(constr);
};



template_implement(List,Surface);
template_implement(List,Construction);
template_implement2(Network,Construction,Room);
