#ifndef AIR_VOLUME_ES_H
#define AIR_VOLUME_ES_H

#include	"building/AirVolume_basic.h"
#include        "transport/Equation_set.h"
#include        "transport/State_vector.h"
class	AirVolume_es_def;
class   Convection;

extern	Type*	AirVolume_es_Type_pointer;


class AirVolume_es : public AirVolume {
protected:
        State_vector    the_state_vector;
        Equation_set    the_equation_set;
        int             the_no_of_divisions;
        Convection*	the_convection;

virtual	get_no_divisions(AirVolume_es_def* def);
public:
	AirVolume_es(Metaclass* meta, AirVolume_es_def* def);
	AirVolume_es(Volume& vol, Substance& sub, Convection* conv,
		     int no_divs, Temperature init_temp);
	AirVolume_es(AirVolume_es& airvol);
	AirVolume_es(APL* theAPL);
	~AirVolume_es();

	void	Destroy(Boolean aborted);
	void	putObject(Boolean deallocate);
	void	deleteObject(Boolean deallocate);
	Type*	getDirectType();

	AirVolume_es& operator=(AirVolume_es& airvol);

        Convection*             convection();
	int                     no_of_divisions();
        State_vector*           state_vector();
        Equation_iterator       equation_iterator();            // NB can be empty
virtual	void                    disc_convection();
};


inline
Type*	AirVolume_es::getDirectType()
{
	return TYPE_OF(AirVolume_es);
};

#endif
