#include	"building/AirVolume_es.h"

#include	"infrastructure/Metaclass.h"
#include        "transport/State_variable.h"
#include        "transport/State_vector.h"
#include        "transport/Equation_set.h"
#include	"building/AirVolume_es_def.h"
#include        "theory/Convection.h"
#include        "theory/Convection_def.h"


static	char*	class_name = "the_air_volume_es";
Type*	AirVolume_es_Type_pointer;


int	AirVolume_es::get_no_divisions(AirVolume_es_def* def)
{
	return 1;
};

AirVolume_es::AirVolume_es(Metaclass* meta, AirVolume_es_def* def)
		: AirVolume_basic(meta, (AirVolume_basic_def*)def),
				  the_equation_set(),
				  the_no_of_divisions(get_no_divisions(def)),
                                  the_state_vector(get_no_divisions(def), this,
						   def->initial_temp())
{
	DEBUG	<< "AirVolume::AirVolume(Metaclass* meta, AirVolume_def* def)\n";

	name(class_name);
	directType(TYPE_OF(Construction_es));
                                                // make a Convection or derived
        the_convection = (Convection*)metaclass->link_to("Convection",
							 def->convection_name() );
};

AirVolume_es::AirVolume_es(Volume& vol, Substance& sub, Convection* conv,
			   int no_divs, Temperature init_temp)
		: AirVolume_basic(vol, sub),
				  the_equation_set(),
				  the_no_of_divisions(no_divs),
				  the_state_vector(no_divs, this,init_temp)
{
	DEBUG	<< "AirVolume_es::AirVolume_es(Volume& vol, Substance& sub, Convection* conv,\n";
	DEBUG	<< "   int no_divs, Temperature init_temp)\n";

	name(class_name);
	directType(TYPE_OF(AirVolume_es));

        the_convection = conv;
};

AirVolume_es::AirVolume_es(AirVolume_es& airvol)
		: AirVolume_basic(airvol.theVolume, airvol.theSubstance),
				  the_equation_set(airvol.the_equation_set),
				  the_no_of_divisions(airvol.the_no_of_divisions),
                                  the_state_vector(airvol.the_state_vector)
{
	DEBUG	<< "AirVolume_es::AirVolume_es(AirVolume_es& airvol)\n";

	name(class_name);
	directType(TYPE_OF(AirVolume_es));

        the_convection = airvol.convection();
};

AirVolume_es::AirVolume_es(APL* theAPL) : AirVolume_basic(theAPL)
{
	RETRIEVE(the_convection);
};

AirVolume_es::~AirVolume_es()
{
	DEBUG	<< "AirVolume_es::~AirVolume_es()\n";

	Destroy(FALSE);
};


void	AirVolume_es::Destroy(Boolean aborted)
{
	DEBUG << "AirVolume_es::Destroy(Boolean aborted)\n";

	if (aborted)
		AirVolume_basic::Destroy(aborted);
};

void	AirVolume_es::putObject(Boolean deallocate)
{
	DEBUG << "AirVolume_es::putObject(Boolean deallocate)\n";

	STORE(the_convection);

	AirVolume_basic::putObject(deallocate);
};

void	AirVolume_es::deleteObject(Boolean deallocate)
{
	DEBUG << "AirVolume_es::deleteObject(Boolean deallocate)\n";

	AirVolume_basic::deleteObject(deallocate);
};


AirVolume_es&	AirVolume_es::operator=(AirVolume_es& airvol)
{
	DEBUG1	<< "AirVolume_es& AirVolume_es::operator=(AirVolume_es& airvol)\n";

	if (&airvol == this)   return (*this);

	(void)AirVolume::operator=(airvol);
        the_state_vector = airvol.the_state_vector;        // shallow copy
	the_no_of_divisions = airvol.the_no_of_divisions;
        the_equation_set = airvol.the_equation_set;        // shallow copy
        the_convection = airvol.convection();

	return (*this);
};


int     AirVolume_es::no_of_divisions()
{
        DEBUG1 << "int     AirVolume_es::no_of_divisions()\n";
                                                // cast guaranteed by Metaclass
        return the_no_of_divisions;
}

Convection*     AirVolume_es::convection()
{
        DEBUG1 << "Condvetion*  AirVolume_es::convection()\n";
                                                // cast guaranteed by Metaclass
        return (Convection*)the_convection;
}

Equation_iterator       AirVolume_es::equation_iterator()
{
        DEBUG1 << "Equation_iterator   AirVolume_es::equation_iterator()\n";

        Equation_iterator       iter(&the_equation_set);
        return iter;                                    // list may be empty 
}

State_vector*   AirVolume_es::state_vector()
{
        DEBUG1 << "State_vector*   AirVolume_es::state_vector()\n";

        return &the_state_vector;
}


void    AirVolume_es::disc_convection()
{
        DEBUG1  << "AirVolume_es::disc_convection()\n";

        // Release the old air equation. ????
	if(the_equation_set.size() != 0) {
		Equation_iterator	eqn_iter = equation_iterator();
		Equation*	eqn;
		while (eqn = eqn_iter(FORWARD))
			delete eqn;
	};
                                        // regernarate eqns every timestep, why???
        the_equation_set = convection()->generate_equations (&the_state_vector,
                                                             this,
                                                             &the_equation_set);
        DEBUG2  << "got equation_set\n";
        DEBUG2  << "AirVolume_es::equation_set =";
        DEBUG2  << "\t" << the_equation_set;
};
