#include	"AirVolume_cfd.h"

#include	"Metaclass.h"
#include	"AirVolume_cfd_def.h"
#include        "State_variable.h"
#include        "State_vector.h"
#include        "Equation_set.h"
#include        "Convection.h"
#include        "Convection_def.h"


static	char*	class_name = "the_air_volume_cfd";
/**/static	char*	class_type = "Air_volume_cfd";


int	AirVolume_cfd::get_no_divisions(AirVolume_es_def* def)
{
	return def->no_of_divisions();
};

AirVolume_cfd::AirVolume_cfd(Metaclass* meta, AirVolume_cfd_def* def)
				: (meta, (AirVolume_es_def*)def),
{
	DEBUG	<< "AirVolume::AirVolume(Metaclass* meta, AirVolume_def* def)\n";

	name(class_name);
/**/	my_type = class_type;
};

AirVolume_es::AirVolume_es(Volume vol, Substance sub, Conduction* conv,
			   int no_divs, Temperature init_temp)
				: (vol, sub, conv, no_divs, init_temp)
{
	DEBUG	<< "AirVolume_cfd::AirVolume_cfd(AirVolume_cfd& airvol)\n";

	name(class_name);
/**/	my_type = class_type;
};

AirVolume_cfd::AirVolume_cfd(AirVolume_cfd& airvol)
				: ((AirVolume_es&)airvol)
{
	DEBUG	<< "AirVolume_cfd::AirVolume_cfd(AirVolume_cfd& airvol)\n";

	name(class_name);
/**/	my_type = class_type;
};

AirVolume_cfd::~AirVolume_cfd()
{
	DEBUG	<< "AirVolume_cfd::~AirVolume_cfd()\n";
};


AirVolume_cfd&	AirVolume_cfd::operator=(AirVolume_cfd& airvol)
{
	DEBUG1	<< "AirVolume_cfd& AirVolume_cfd::operator=(AirVolume_cfd& airvol)\n";

	if (&airvol == this)   return (*this);

	(void)AirVolume_es::operator=((AirVolume_es&)airvol);

	return (*this);
};


void    AirVolume_cfd::disc_conduction()
{
        DEBUG1  << "AirVolume_cfd::disc_conduction()\n";

					// carry out cfd calculations

                                        //// modify eqns in place, so why copy???
        the_equation_set = *convection()->generate_equations (&the_state_vector,
                                                                this,
                                                                &the_equation_set);
        DEBUG2  << "got equation_set\n";
        DEBUG2  << "AirVolume_cfd::equation_set =";
        DEBUG2  << "\t" << the_equation_set;
};

