#ifndef AIR_VOLUME_BASIC_H
#define AIR_VOLUME_BASIC_H

/* Has a volume value, got from caller, and a substance */

#include	"dimensions/Mass.h"
#include	"transport/Substance.h"
#include	"building/AirVolume.h"
class	AirVolume_basic_def;

extern	Type*	AirVolume_basic_Type_pointer;


class AirVolume_basic : public AirVolume {
protected:
	EKSObject*	my_caller;		// Space
        Substance	theSubstance;		// substance filling the volume
public:
	AirVolume_basic(Metaclass* meta, AirVolume_basic_def* def);
	AirVolume_basic(Volume vol, Substance& sub);
	AirVolume_basic(AirVolume_basic& airvol);
	AirVolume_basic(APL* theAPL);
	~AirVolume_basic();

	Type*	getDirectType();
 
	AirVolume_basic& operator=(AirVolume_basic& airvol);

	Substance	substance();
        Mass		mass();
};
 

inline
Type*	AirVolume_basic::getDirectType()
{
	return TYPE_OF(AirVolume_basic);
};

inline
Substance	AirVolume_basic::substance()
{
        return theSubstance;
};


inline
Mass	AirVolume_basic::mass()
{
        return Mass(theSubstance.density() * theVolume);
};

#endif
