#include	"AirVolume.h"

#include	"Metaclass.h"
#include	"AirVolume_def.h"
#include	"Volume.h"
#include	"Mass.h"
#include	"Room.h"

static	char*	class_name = "the_air_volume";
/**/static	char*	class_type = "Air_volume";


AirVolume::AirVolume(Metaclass* meta, AirVolume_def* def) : (meta),
					theVolume(0.0),
					theSubstance(def->substance())
{
	DEBUG	<< "AirVolume::AirVolume(Metaclass* meta, AirVolume_def* def)\n";

	name(class_name);
/**/	my_type = class_type;

	my_caller = def->caller();	// set by caller before instantiating
};

AirVolume::AirVolume(Volume vol, Substance& sub)  : (NULLPTR(Metaclass)),
						  theVolume(vol), theSubstance(sub)
{
	DEBUG	<< "AirVolume::AirVolume(Volume vol, Substance& sub)\n";

	name(class_name);
/**/	my_type = class_type;
	my_caller = NULLPTR(EKSObject);
};

AirVolume::AirVolume(AirVolume& airvol)  : (airvol.metaclass),
		theVolume(airvol.theVolume), theSubstance(airvol.theSubstance)
{
	DEBUG	<< "AirVolume::AirVolume(AirVolume& airvol)\n";

	name(class_name);
/**/	my_type = class_type;

	my_caller = airvol.my_caller;
};

AirVolume::~AirVolume()
{
	DEBUG	<< "AirVolume::~AirVolume()\n";
};


AirVolume&	AirVolume::operator=(AirVolume& airvol)
{
	DEBUG1	<< "AirVolume&   AirVolume::operator=(AirVolume& airvol)\n";

	if (&airvol == this)   return (*this);

	theVolume = airvol.theVolume;
	theSubstance = airvol.theSubstance;

	return (*this);
};


Volume		AirVolume::volume()
{
	DEBUG1	<< "Volume   AirVolume::volume()\n";

					// cast guaranteed by Metaclass
	if (theVolume == 0.0)
		theVolume = ((Room*)my_caller)->volume();
	return theVolume;
};

Substance	AirVolume::substance()
{
	DEBUG1	<< "Substance*   AirVolume::substance()\n";

	return theSubstance;
};

Mass		AirVolume::mass()
{
	DEBUG1	<< "Mass   AirVolume::mass()\n";

	return Mass(volume() * theSubstance.density());
};

