#include	"building/AirVolume_basic.h"

#include	"infrastructure/Metaclass.h"
#include	"transport/Substance.h"
#include	"building/AirVolume_basic_def.h"
//#include	"building/Room.h"

static	char*	class_name = "the_air_volume_basic";
Type*	AirVolume_basic_Type_pointer;


AirVolume_basic::AirVolume_basic(Metaclass* meta, AirVolume_basic_def* def)
					: AirVolume(meta, (AirVolume_def*)def),
					  theSubstance(def->substance())
{
	DEBUG	<< "AirVolume_basic::AirVolume_basic(Metaclass* meta, AirVolume_basic_def* def)\n";

	name(class_name);
        directType(TYPE_OF(AirVolume_basic));

	my_caller = def->caller();	// set by caller before instantiating
};

AirVolume_basic::AirVolume_basic(Volume vol, Substance& sub)  : AirVolume(vol),
						    theSubstance(sub)
{
	DEBUG	<< "AirVolume_basic::AirVolume_basic(Volume vol, Substance& sub)\n";

	name(class_name);
        directType(TYPE_OF(AirVolume_basic));

	my_caller = NULLPTR(EKSObject);
};

AirVolume_basic::AirVolume_basic(AirVolume_basic& airvol)
		: AirVolume((AirVolume&)airvol), theSubstance(airvol.theSubstance)
{
	DEBUG	<< "AirVolume_basic::AirVolume_basic(AirVolume_basic& airvol)\n";

	name(class_name);
        directType(TYPE_OF(AirVolume_basic));

	my_caller = airvol.my_caller;
};

AirVolume_basic::AirVolume_basic(APL* theAPL)
					: AirVolume(theAPL), theSubstance(theAPL)
{};

AirVolume_basic::~AirVolume_basic()
{
	DEBUG	<< "AirVolume_basic::~AirVolume_basic()\n";
};


AirVolume_basic&	AirVolume_basic::operator=(AirVolume_basic& airvol)
{
	DEBUG1	<< "AirVolume_basic&   AirVolume_basic::operator=(AirVolume_basic& airvol)\n";

	if (&airvol == this)   return (*this);

	AirVolume::operator=((AirVolume&)airvol);
	theSubstance = airvol.theSubstance;

	return (*this);
};
