#include	"transport/Vertex.h"

#include	<math.h>


Vertex::Vertex(Length xval, Length yval, Length zval) : the_x(xval),
							the_y(yval),
							the_z(zval)
{
	DEBUG << "Vertex::Vertex(Length xval, Length yval, Length zval)\n";
}

Vertex::Vertex(Vertex& vert)  : the_x(vert.the_x), the_y(vert.the_y),
				the_z(vert.the_z)
{
	DEBUG << "Vertex::Vertex(Vertex& vert)\n";
}


Vertex& Vertex::operator=(Vertex& vert)
{
	DEBUG1 << "Vertex& Vertex::operator=(Vertex& vert)\n";

	the_x = vert.the_x;
	the_y = vert.the_y;
	the_z = vert.the_z;

	return *this;
}

Length Vertex::x()
{
	DEBUG1	<< "Length Vertex::x()\n";

	return the_x;
};

Length Vertex::y()
{
	DEBUG1	<< "Length Vertex::y()\n";

	return the_y;
};

Length Vertex::z()
{
	DEBUG1	<< "Length Vertex::z()\n";

	return the_z;
};

Length Vertex::magnitude()
{
	DEBUG1	<< "Length Vertex::magnitude()\n";

	return Length(sqrt((the_x*the_x+the_y*the_y+the_z*the_z).value()));     
};
