#ifndef	VECTOR_H
#define VECTOR_H

#include	"infrastructure/EKS.h"


class Vector {
protected:
	float*	data;
	int	size;
public:
	Vector(int n);
	Vector(int n, float val);
	Vector(Vector& v);		           // deep copy
	~Vector();

	int	dimensionality();
	float&	operator[](int i);
	Vector&	operator=(Vector& v);		// deep copy
	void	clear(float val = 0);
	Boolean	operator==(Vector& v);
friend	Vector	operator+(Vector& v1, Vector& v2);
friend	Vector	operator-(Vector& v1, Vector& v2);
//friend	Vector	operator*(Vector& v1, Vector& v2);

friend	ostream&	operator<<(ostream& s, Vector& v);
};
#endif
