#include	"transport/Vector.h"


Vector::Vector(int n)			{ data = new float[size = n]; };

Vector::Vector(int n, float val)	{ data = new float[size = n];
					  clear(val);
					}

Vector::Vector(Vector& v)
{
	data = new float[size=v.size];
	for (int i=0; i<size; i++)
		data[i] = v.data[i];
};

Vector::~Vector()			{ delete [size] data; };

int	Vector::dimensionality()	{ return size; };

float&	Vector::operator[](int i)	{ return data[i]; };

void	Vector::clear(float val)
{
	for (int i=0; i<size; i++)
		data[i] = val;
};

Vector&	Vector::operator=(Vector& v)
{
	for (int i=0; i<size; i++)
		data[i] = v.data[i];
	return *this;
};

Boolean	Vector::operator==(Vector& v)
{
	for (int i=0; i<size; i++)
		if (data[i] != v.data[i])
			return FALSE;
	return TRUE;
};

Vector	operator+(Vector& v1, Vector& v2)
{	Vector v(v1.size);
	for (int i=0; i<v.size; i++)
		v.data[i] = v1.data[i] + v2.data[i];
	return v;
};

Vector	operator-(Vector& v1, Vector& v2)
{	Vector v(v1.size);
	for (int i=0; i<v.size; i++)
		v.data[i] = v1.data[i] - v2.data[i];
	return v;
};

ostream&	operator<<(ostream& s, Vector& v)
{
	s << "[" << v[0];
	for (int i = 1; i < v.size; i++)
		s << ", " << v[i];
	s << "]\n";

	return s;
};
