#ifndef TIME_H
#define TIME_H

#include	"infrastructure/EKS.h"

/*
** Represents time in year, month, day,
** hour, minute and second.
** NB Time_of_day does not have a = or += operators
** because it is passed as a parameter and must
** not be incremented.
*/


class Time_of_day {
	float t_total_sec;
	int t_year;
	int t_day;
	int t_month;
	int t_hour;
	int t_min;
	float t_sec;

	Time_of_day(float secs);
	int		compare(const Time_of_day& t) const;
						     // -1 means <, 0 means ==.
////	Time_of_day&	operator=(Time_of_day& t);
	float		as_secs();
public:
	Time_of_day(float sc, int mn, int hr, int dy, int yr);
	Time_of_day(const Time_of_day& t);

	int		year() const		{ return t_year; }
	int		day() const		{ return t_day; }
	int		month() const		{ return t_month; }
	int		hour() const		{ return t_hour; }
	int		min() const		{ return t_min; }
	float		sec() const		{ return t_sec; }

	Time_of_day&	operator=(const Time_of_day& t);////? tut tut
	int		operator<(const Time_of_day& t) const
						{ return compare(t) < 0; }
	int		operator<=(const Time_of_day& t) const
						{ return compare(t) <= 0; }
	int		operator>(const Time_of_day& t) const
						{ return compare(t) > 0; }
	int		operator>=(const Time_of_day& t) const
						{ return compare(t) >= 0; }
	int		operator==(const Time_of_day& t) const
						{ return compare(t) == 0; }
	int		operator!=(const Time_of_day& t) const
						{ return compare(t) != 0; }

	Time_of_day	operator+(const Time_of_day& t) const;
	Time_of_day	operator-(const Time_of_day& t) const;
	Time_of_day	operator*(int i) const;
	float		operator/(Time_of_day& t);

friend	ostream&	operator<<(ostream& s, Time_of_day& t);
};

#endif
