#include	"transport/Time_of_day.h"


Time_of_day::Time_of_day(float sc, int mn, int hr, int dy, int yr)
{
	DEBUG << "Time_of_day(float sc, int mn, int hr, int dy, int yr)\n";
	t_total_sec = -1;
	t_sec = sc;
	t_min = mn;
	t_hour = hr;
	t_day = dy;
	t_year = yr;
				// Ensure well formed Time_of_day.
	if (t_sec < 0) {
		t_min += int(t_sec/60) - 1;
		t_sec += 60 - int(t_sec/60)*60;
	};
	if (t_sec > 59) {
		t_min += int(t_sec/60);
		t_sec -= int(t_sec/60)*60;
	};
	if (t_min < 0)
		{ t_hour += t_min/60 - 1; t_min = 60 + (t_min%60); };
	if (t_min > 59)   { t_hour += t_min/60; t_min %= 60; };
	if (t_hour < 0)
		{t_day += t_hour/24 - 1; t_hour = 24 + (t_hour%24); };
	if (t_hour > 23)   { t_day += t_hour/24; t_hour %= 24; };
	if (t_day < 0)
		{ t_year += t_day/365 - 1; t_day = 365 + (t_day%365); };
	if (t_day > 364)   { t_year += t_day/365; t_day %= 365; };
				// -ve year => interval is -ve
				// Not really sensible, so negate.
	if (t_year < 0)
		(void)operator= (Time_of_day(-sc, -mn, -hr, -dy, -yr));
}

Time_of_day::Time_of_day(const Time_of_day& t)
{
	DEBUG << "Time_of_day(Time_of_day& t)\n";
	t_total_sec = t.t_total_sec;
	t_sec = t.sec();
	t_min = t.min();
	t_hour = t.hour();
	t_day = t.day();
	t_year = t.year();
}


Time_of_day Time_of_day::operator+(const Time_of_day& t) const
{
	DEBUG << "Time_of_day::operator+\n";

	return Time_of_day(t_sec+t.t_sec, t_min+t.t_min, t_hour+t.t_hour,
			   t_day+t.t_day, t_year+t.t_year);
}

Time_of_day Time_of_day::operator-(const Time_of_day& t) const
{
	DEBUG << "Time_of_day::operator-\n";

	return Time_of_day(t_sec-t.t_sec, t_min-t.t_min, t_hour-t.t_hour,
			   t_day-t.t_day, t_year-t.t_year);
}

Time_of_day Time_of_day::operator*(int i) const
{
	DEBUG << "Time_of_day::operator=\n";

	return Time_of_day(t_sec*i, t_min*i, t_hour*i, t_day*i, t_year*i);
}

float Time_of_day::operator/(Time_of_day& t)
{
	DEBUG << "Time_of_day::operator=\n";

		return as_secs() / t.as_secs();
};


int Time_of_day::compare(const Time_of_day& t) const
{
	DEBUG << "Time_of_day::compare(Time_of_day& t)\n";
	if (year() < t.year())
		return(-1);
	else if (year() > t.year())
		return(1);
	if (day() < t.day())
		return(-1);
	else if (day() > t.day())
		return(1);
	if (hour() < t.hour())
		return(-1);
	else if (hour() > t.hour())
		return(1);
	if (min() < t.min())
		return(-1);
	else if (min() > t.min())
		return(1);
	if (sec() < t.sec())
		return(-1);
	else if (sec() > t.sec())
		return(1);
	return(0);
};



Time_of_day::Time_of_day(float secs)
{
	DEBUG << "Time_of_day(float secs)\n";

	t_total_sec = secs;
	int	mins = (int)secs / 60;
	int	hours = mins / 60;
	int	days = hours / 24;
	int	years = days / 365;

	t_sec = secs - mins*60;
	t_min = mins - hours*60;
	t_hour = hours - days*24;
	t_day = days - years * 365;
	t_year = years;
};

Time_of_day& Time_of_day::operator=(const Time_of_day& t)
{
	DEBUG << "Time_of_day::operator=\n";
	if (this==&t) return (*this);
	t_total_sec = t.t_total_sec;
	t_sec = t.t_sec;
	t_min = t.t_min;
	t_hour = t.t_hour;
	t_day = t.t_day;
	t_year = t.t_year;
	return (*this);
}

float	Time_of_day::as_secs()
{
	if (t_total_sec == -1)
		t_total_sec = (((((((t_year*365)
				         + t_day )*24)
					      + t_hour )*60)
						     + t_min )*60)
						           + t_sec;
	return t_total_sec;
};


ostream&	operator<<(ostream& s, Time_of_day& t)
{
	DEBUG1	<< "operator<<(ostream& s, Time_of_day& t)\n";

	s << t.t_day << "/" << t.t_month << "/" << t.t_year << "__"
	  << t.t_hour << ":" << t.t_min << ":" << t.t_sec;
};
