#ifndef SUN_POSITION_H
#define SUN_POSITION_H

#include	"infrastructure/EKS.h"


class Sun_position {
				/* Degrees, clockwise from north -
				 * range 0 to 360.  When the altitude
				 * is negative the azimuth is set to
				 * zero. */
	float p_azimuth;

				/* Degrees, measured from horizontal
				 * - range 0 to 360.  The altitude
				 * is negative post-sunset to
				 * pre-sunrise. */
	float p_elevation;

				/* The angular position of the sun at
				 * solar noon with respect to the
				 * plane of the equator (north +ve).
				 */
	float p_declination;
public:
	Sun_position(float a_azimuth, float a_elevation,
		     float a_declination);
	Sun_position(Sun_position& s);
	~Sun_position();

	Sun_position& operator=(Sun_position& s);

	float azimuth();
	float elevation();
	float declination();

friend	ostream&	operator<<(ostream& s, Sun_position& p);
};

#endif
