#include	"transport/Sun_position.h"


Sun_position::Sun_position(float a_azimuth, float a_elevation,
	float a_declination)
{
	DEBUG << "Sun_position::Sun_position(float a_azimuth,\n";
	DEBUG << "  float a_elevation, float a_declination)\n";

	p_azimuth=a_azimuth;
	p_elevation=a_elevation;
	p_declination=a_declination;
}

Sun_position::Sun_position(Sun_position& s)
{
	DEBUG << "Sun_position::Sun_position(Sun_position& s)\n";

	p_azimuth=s.p_azimuth;
	p_elevation=s.p_elevation;
	p_declination=s.p_declination;
}

Sun_position::~Sun_position()
{
	DEBUG << "Sun_position::~Sun_position()\n";
}

Sun_position& Sun_position::operator=(Sun_position& s)
{
	DEBUG << "Sun_position& Sun_position::operator=(Sun_position& s)\n";

	if(this==&s) return (*this);
	p_azimuth=s.p_azimuth;
	p_elevation=s.p_elevation;
	p_declination=s.p_declination;
	return (*this);
}

float Sun_position::azimuth()
{
	return p_azimuth;
}

float Sun_position::elevation()
{
	return p_elevation;
}

float Sun_position::declination()
{
	return p_declination;
}


ostream&	operator<<(ostream& s, Sun_position& p)
{
	DEBUG1	<< "operator<<(ostream& s, Sun_position& p)\n";

	s << p.p_azimuth << "Z" << p.p_elevation << "L("
	  << p.p_declination << "D)";
};
