#ifndef SUBSTANCE_H
#define SUBSTANCE_H

#include	"dimensions/ThermalConductivity.h"
#include	"dimensions/Density.h"
#include	"dimensions/SpecificHeatCapacity.h"
class	APL;

/* base class for Fluid and Solid classes.  Substances are assigned to
a derived class on the basis of states at standard temperature and
pressure (i.e pressure of 1013 k Pa and temperature of 293 K).

I have left out 'description' as this will be done by a String class
when we have one sorted out. */
 

class Substance {
protected:
	ThermalConductivity	the_thermalConductivity;
	Density			the_density;
	float			the_refractiveIndex;	//non-dimensional
	SpecificHeatCapacity	the_specificHeatCapacity;//per unit mass
public:
	Substance (ThermalConductivity thCon, Density den, 
		   SpecificHeatCapacity shc, float refractiveIndex);
	Substance(char* material_name);
	Substance(Substance& l);
	Substance(APL* theAPL);
	~Substance();

	Substance& operator=(Substance& l);

	Diffusivity		diffusivity();
	ThermalConductivity	thermalConductivity();
	Density			density();
	float			refractiveIndex();
	SpecificHeatCapacity	specificHeatCapacity();
	Dimension		volumeThermalCapacity();	// ???dmr
};

#endif
