#include	"transport/Substance.h"

#include	<string.h>
#include	"dimensions/Diffusivity.h"


Substance::Substance(ThermalConductivity thCon, Density den,
                     SpecificHeatCapacity shc, float rfIndex)
{
	DEBUG << "Substance::Substance(ThermalConductivity thCon, Density den,\n";
	DEBUG << "			SpecificHeatCapacity shc, float rfIndex)\n";

	the_thermalConductivity = thCon;
	the_density = den;
	the_specificHeatCapacity = shc;
	the_refractiveIndex = rfIndex;
};

Substance::Substance(char* material_name)
{
	DEBUG << "Substance::Substance(char* material_name)\n";

					/* lookup properties in database? */
	if (!strcmp(material_name,"brick")) {
		the_thermalConductivity = .84;
		the_density = 1700;
		the_specificHeatCapacity = 800;
		the_refractiveIndex = 0;
	} else if (!strcmp(material_name,"concrete")) {
		the_thermalConductivity = 1.4;
		the_density = 2100;
		the_specificHeatCapacity = 653;
		the_refractiveIndex = 0;
	} else if (!strcmp(material_name,"metal")) {
		the_thermalConductivity = 50;
		the_density = 7800;
		the_specificHeatCapacity = 502;
		the_refractiveIndex = 0;
	} else if (!strcmp(material_name,"wood")) {
		the_thermalConductivity = 0.16;
		the_density = 800;
		the_specificHeatCapacity = 2093;
		the_refractiveIndex = 0;
	} else if (!strcmp(material_name,"air")) {
		the_thermalConductivity = 0.02;
		the_density = 1;
		the_specificHeatCapacity = 100;
		the_refractiveIndex = 1;
	} else {
		cerr << "Substance: dont recognise material " << material_name
		     << ", using brick\n";
		the_thermalConductivity = .84;
		the_density = 1700;
		the_specificHeatCapacity = 837;
		the_refractiveIndex = 0;
	};
};

Substance::Substance(Substance& l)
{
	DEBUG << "Substance::Substance(Substance& l)\n";

	the_thermalConductivity = l.the_thermalConductivity;
	the_density = l.the_density;
	the_specificHeatCapacity = l.the_specificHeatCapacity;
	the_refractiveIndex = l.the_refractiveIndex;
};

Substance::Substance(APL* theAPL)
{
	DEBUG << "Substance(APL* theAPL)\n";
};

Substance::~Substance()
{
	DEBUG << "Substance::~Substance()\n";
}


Substance& Substance::operator=(Substance& l)
{
	DEBUG1 << "Substance::operator=(Substance& l)\n";

	if(this == &l) return (*this);

	the_thermalConductivity = l.the_thermalConductivity;
	the_density = l.the_density;
	the_specificHeatCapacity = l.the_specificHeatCapacity;
	the_refractiveIndex = l.the_refractiveIndex;	

	return (*this);
}


Diffusivity	Substance::diffusivity()
{
	DEBUG1 << "Diffusivity	Substance::diffusivity()\n";

	return Diffusivity(the_thermalConductivity/
					volumeThermalCapacity());
};

ThermalConductivity Substance::thermalConductivity() 
{
	DEBUG1 << "ThermalConductivity  Substance::thermalConductivity()\n";

	return the_thermalConductivity;
};

Density	Substance::density()
{
	DEBUG1 << "Density  Substance::density()\n";

	return the_density;
}

float	Substance::refractiveIndex()
{
	DEBUG1 << "float  Substance::refractiveIndex()\n";

	return the_refractiveIndex;
};

SpecificHeatCapacity	Substance::specificHeatCapacity()
{
	DEBUG1 << "SpecificHeatCapacity  Substance::specificHeatCapacity()\n";

	return the_specificHeatCapacity;
};

Dimension Substance::volumeThermalCapacity()
{
	DEBUG1 << "Dimension  Substance::volumeThermalCapacity()\n";

	return the_specificHeatCapacity * the_density;
}
