#ifndef STATE_VECTOR_H
#define STATE_VECTOR_H


#include	"infrastructure/EKS.h"
#include	"infrastructure/list.h"
#include	"transport/State_variable.h"
#include	"dimensions/Temperature.h"
template_define(List,State_variable);
class	APL;


class State_vector : public List(State_variable) {
	List_iterator(State_variable)	sv_iter;
public:
	State_vector(int dimension, EKSObject* owner, Temperature& initial_value);
	State_vector(State_vector& sv);				// shallow copy
	State_vector(APL* theAPL);
	~State_vector();

	State_vector& operator=(State_vector& sv);		// shallow copy

	State_variable*	operator[](int i);
	List_iterator(State_variable)	iterator();


friend	ostream&	operator<<(ostream& s, State_vector& es);
};

#endif

