#include	"transport/State_vector.h"


State_vector::State_vector(int dimension, EKSObject* owner, Temperature& initial_value)
				: (), sv_iter(this)
{
	DEBUG	<< "State_vector::State_vector(int dimension, EKSObject* owner, Temperature& initial_value)\n";

	for (int i = 0; i < dimension; i++) {		// create the State variables
		State_variable*	sv = new State_variable(owner, initial_value.value());
		append(sv);
	};
};


State_vector::State_vector(State_vector& sv)  : (sv), sv_iter(this)
{
	DEBUG	<< "State_vector::State_vector(State_vector& sv)\n";
};

State_vector::State_vector(APL* theAPL)
{
	DEBUG << "State_vector(APL* theAPL)\n";
};

State_vector::~State_vector()
{
	DEBUG	<< "State_vector::~State_vector()\n";
};


State_vector& State_vector::operator=(State_vector& sv)
{
	DEBUG1 << "State_vector::operator=(State_vector& sv)\n;"

	(void)	List(State_variable)::operator=(sv);

	return *this;
}


State_variable*	State_vector::operator[](int i)
{
	return sv_iter[i];
};

List_iterator(State_variable)	State_vector::iterator()
{
	List_iterator(State_variable) iter(this);

	return iter;
};


ostream&	operator<<(ostream& s, State_vector& svec)
{
	s << "state vector for " << (int)svec.sv_iter[0]->owner() << "\n";
	svec.sv_iter(RESET);
	State_variable* sv;
	while (sv = svec.sv_iter(FORWARD))
		s << "    " << sv->state_variable();
	s << "\n\n";

	return s;
};


template_implement(List,State_variable);
