#ifndef STATE_VARIABLE_H
#define STATE_VARIABLE_H

#include	"infrastructure/EKS.h"
class	EKSObject;

/* 
** State_variable contains the node identifier information.
*/


class State_variable {
private:
static	int	next_id;	/* next available int for labeling SVs*/
protected:
	int	the_id;		/* unique id of region of space the SV represents*/
	float	the_value;	/* value of the state variable */
	EKSObject*	the_owner; /* EKS object containing the SV (eg Layer) */
public:
	State_variable(EKSObject* an_owner, float a_value);		// 
	State_variable(State_variable& n);	// new obj => new id, copies value
	~State_variable();

	State_variable& operator=(State_variable& n);	// copies value only

	EKSObject*	owner();
	int		id();
	float		state_variable();

	void		state_variable(float	value);

friend	ostream&	operator<<(ostream& s, State_variable& sv);
};

#endif

