#include	"transport/Profile.h"

#include	<string.h>
#include	<stdlib.h>
#include	<osfcn.h>

Profile::Profile(char* a_name, int initial_size)
{
	the_name = strdup(a_name);

	if (initial_size < 0) {
		cerr << "Profile: stupid initial size hint (" << initial_size << ")\n";
		initial_size = 10;
	};

	the_allocated_size = initial_size;
	the_data = (double*)malloc(the_allocated_size * sizeof(double));
	the_data_size = 0;
};

Profile::Profile(Profile& a_profile)
{
	the_name = strdup(a_profile.the_name);
	the_data_size = a_profile.the_data_size;
	the_allocated_size = a_profile.the_allocated_size;

	the_data = (double*)malloc(the_allocated_size * sizeof(double));

	for (int i = 0; i < the_data_size; i++)
		the_data[i] = a_profile.the_data[i];
};

Profile::~Profile()
{
	delete the_data;
	delete the_name;
};

Profile&	Profile::operator=(Profile& a_profile)
{
	DEBUG << "Climatic_Profile& Climatic_Profile::operator=";
	DEBUG << "(Climatic_Profile& i)\n";
	if (this==&a_profile) return *this;
	delete the_name;
	the_name = strdup(a_profile.the_name);
	the_allocated_size = a_profile.the_allocated_size;
	the_data_size = a_profile.the_data_size;

	the_data = (double*)realloc((char*)the_data, the_allocated_size * sizeof(double));

	for (int i = 0; i < the_data_size; i++)
		the_data[i] = a_profile.the_data[i];

	return *this;
};

void	Profile::append(double a_datum)
{
	if (the_data_size == the_allocated_size) {
		the_allocated_size += 10;
		the_data=(double*)realloc((char*)the_data,the_allocated_size*sizeof(double));
	};

	the_data[the_data_size++] = a_datum;
};
