#ifndef POLYGON_H
#define POLYGON_H

#include	"infrastructure/EKS.h"
#include	"dimensions/Area.h"
class	PlaneEquation;
class	Vertex;
#include	"infrastructure/list.h"
template_define(List,Vertex);

/* Some functions are not specific to Polygon etc. but can be defined
** generally for a list of vertices. Hence this is made a proper class.
*/
class Polygon {
protected:
        List(Vertex)	the_vertices;

	Area		xSum();
	Area		ySum();
	Area		zSum();
public:
        Polygon(List(Vertex)& vert_list);		// deep copy
        Polygon(Polygon& lverts);			// deep copy
        ~Polygon();

        Polygon&	operator=(Polygon& lverts);	// deep copy

	List_iterator(Vertex)	get_iterator();
	int		size();
	Area		area();
	PlaneEquation	planeEquation();
	void		printVertices();
};

#endif
