#include	"transport/Polygon.h"

#include	<math.h>
#include	"transport/Vertex.h"
#include	"transport/PlaneEquation.h"


Polygon::Polygon(List(Vertex)& a_list) : the_vertices()
{
	DEBUG << "Polygon(Vertex_list& a_list)\n";

        List_iterator(Vertex) index(&a_list);
        Vertex* member;
        while(member=index(FORWARD))
                the_vertices.append(member);
};

Polygon::Polygon(Polygon& ply) : the_vertices()
{
	DEBUG << "Polygon(Polygon& ply)\n";

        List_iterator(Vertex) index(&(ply.the_vertices));
        Vertex* member;
        while(member=index(FORWARD))
                the_vertices.append(member);
};

Polygon::~Polygon()
{
	DEBUG << "~Polygon()\n";

        List_iterator(Vertex) myindex(&the_vertices);
        Vertex* member;
        while(member=myindex(FORWARD))
                delete member;
        the_vertices.clear();
};


Polygon& Polygon::operator=(Polygon& ply)    
{
	DEBUG1 << "Polygon::operator=(Polygon& ply)\n";

        if (this==&ply) return (*this);
 
        List_iterator(Vertex) myindex(&the_vertices);
        Vertex* member;
        while(member=myindex(FORWARD))
                delete member;
	the_vertices.clear();

        List_iterator(Vertex) index(&(ply.the_vertices));
        while(member=index(FORWARD))
                the_vertices.append(member);

        return (*this);
};

List_iterator(Vertex)	Polygon::get_iterator()
{
	DEBUG1 << "List_iterator(Vertex)	Polygon::get_iterator()\n";

	List_iterator(Vertex) iter(&the_vertices);
	return iter;
};

int	Polygon::size()
{
	DEBUG1	<< "int Polygon::size()\n";

	return get_iterator().size();
}

Area Polygon::xSum()
{
	DEBUG1 << "Area Polygon::xSum()\n";

	Dimension a_xSum(0.0);
        List_iterator(Vertex) jcount(&the_vertices);
        List_iterator(Vertex) kcount(&the_vertices);
        Vertex* j;
        Vertex* k;
        kcount(FORWARD);
        while (j=jcount(FORWARD)) {
                k=kcount(FORWARD);
                if (k==0) {
                        k=the_vertices.first();
                        kcount(RESET);
                }
                a_xSum=a_xSum + j->y()*k->z() - j->z()*k->y();
	}
	return Area(a_xSum);
}

Area Polygon::ySum()
{
	DEBUG1 << "Area Polygon::ySum()\n";

	Dimension a_ySum(0.0);
        List_iterator(Vertex) jcount(&the_vertices);
        List_iterator(Vertex) kcount(&the_vertices);
        Vertex* j;
        Vertex* k;
        kcount(FORWARD);
        while (j=jcount(FORWARD)) {
                k=kcount(FORWARD);
                if (k==0) {
                        k=the_vertices.first();
                        kcount(RESET);
                }
                a_ySum=a_ySum + j->z()*k->x() - j->x()*k->z();
	}
	return Area(a_ySum);
}

Area Polygon::zSum()
{
	DEBUG1 << "Area Polygon::zSum()\n";

	Dimension a_zSum(0.0);
        List_iterator(Vertex) jcount(&the_vertices);
        List_iterator(Vertex) kcount(&the_vertices);
        Vertex* j;
        Vertex* k;
        kcount(FORWARD);
        while (j=jcount(FORWARD)) {
                k=kcount(FORWARD);
                if (k==0) {
                        k=the_vertices.first();
                        kcount(RESET);
                }
                a_zSum=a_zSum + j->x()*k->y()- j->y()*k->x();
	}
	return Area(a_zSum);
}

Area Polygon::area()
{
	DEBUG1 << "Area Polygon::area()\n";

	float fsum=pow(xSum().value(),2)+
	pow(ySum().value(),2)+
	pow(zSum().value(),2);
	Area ar(0.5 * pow(fsum,0.5));
	return ar;
}

PlaneEquation Polygon::planeEquation()
{
	DEBUG1 << "Polygon::planeEquation()\n";

	// return equation of plane of vertices if all lie in same plane
	if (size() < 3)
	{
		cout << "Polygon::planeEquation() : Too few vertices\n";
		exit(-1);
	}
	else
	{
		// create plane equation from first three vertices
		List_iterator(Vertex) index(&the_vertices);
		PlaneEquation planeEqn(*index[0],*index[1],*index[2]);
		Vertex* member;

		while (member=index(FORWARD) ) 
		{  
		    int inplane=planeEqn.inPlane(*member);

		    if (inplane == 0)
		    {
			cout<<"Polygon::planeEquation() : not a plane\n";
			exit(-1);
		    }
		}
	return planeEqn;
	}
}

void Polygon::printVertices()
{
	DEBUG1 << "void Polygon::printVertices()\n";

	List_iterator(Vertex) index(&the_vertices);
	Vertex* member;
	while (member=index(FORWARD) ) 
	    cout<<"("<<member->x()<<", "<<member->y()<<", "<<member->z()
		<<")\n";
}



template_implement(List,Vertex);
