#ifndef PLANEEQUATION_H
#define PLANEEQUATIONH 

#include	"infrastructure/EKS.h"
class	Vertex;

/* Equation of a plane in implicit form xMult*x + yMult*y + zMult*z + d=0 */


class PlaneEquation {
protected:
        float	xMult, yMult, zMult;
	float	d;
	void normalise();
public:
        PlaneEquation(float xm, float ym, float zm, float dv);
	PlaneEquation(Vertex vj, Vertex vk, Vertex vl);

	float xCosine();
	float yCosine();
	float zCosine();
	float constantValue();
	int inPlane(Vertex& v); 	//returns 1 when true, otherwise 0
	void printOn();
};

#endif
