#include	"transport/PlaneEquation.h"

#include	<math.h>
#include	<stdlib.h>
#include	"dimensions/Dimension.h"
#include	"transport/Vertex.h"


PlaneEquation::PlaneEquation(float xm, float ym, float zm, float dv)
{
	DEBUG << "PlaneEquation::PlaneEquation(float xm, float ym, float zm, float dv)\n";
					// create in normalised form
	xMult=xm;
	yMult=ym;
	zMult=zm;
	d=dv;

	float norm=pow(xMult*xMult + yMult*yMult + zMult*zMult, 0.5);
	if (norm>0)
	{
		xMult=xMult/norm;
		yMult=yMult/norm;
		zMult=zMult/norm;
		d=d/norm;
	}
	else
	{
		cout << " PlaneEquation::normalise value is 0\n";
		exit(-1);
	}
};

PlaneEquation::PlaneEquation(Vertex vj, Vertex vk, Vertex vl)
{
	DEBUG << "PlaneEquation::PlaneEquation(Vertex vj, Vertex vk, Vertex vl)\n";
				/* create a plane equation from 3 vertices
				 * (from 'A programmers geometry',
				 * Bowyer and Woodwark, Butterworths
				 */
	Dimension xkj,ykj,zkj,xlj,ylj,zlj;
	xkj=vk.x()-vj.x();
	ykj=vk.y()-vj.y();
	zkj=vk.z()-vj.z();
	xlj=vl.x()-vj.x();
	ylj=vl.y()-vj.y();
	zlj=vl.z()-vj.z();
	
	xMult=(ykj * zlj - zkj * ylj).value();
	yMult=(zkj * xlj - xkj * zlj).value();
	zMult=(xkj * ylj - ykj * xlj).value();
	d= -1. * ( vk.x()*xMult + vk.y()*yMult + vk.z()*zMult ).value();
	normalise();
}

void PlaneEquation::normalise()
{
	DEBUG1 << "void PlaneEquation::normalise()\n";

	float norm=pow(xMult*xMult + yMult*yMult + zMult*zMult, 0.5);
	if (norm>0)
	{
		xMult=xMult/norm;
		yMult=yMult/norm;
		zMult=zMult/norm;
		d=d/norm;
	}
	else
	{
		cout << " PlaneEquation::normalise value is 0\n";
		exit(-1);
	}
}

float PlaneEquation::xCosine()
{
	DEBUG1 << "float PlaneEquation::xCosine()\n";

	return xMult;
};

float PlaneEquation::yCosine()
{
	DEBUG1 << "float PlaneEquation::yCosine()\n";

	return yMult;
};

float PlaneEquation::zCosine()
{ 
	DEBUG1 << "float PlaneEquation::zCosine()\n";

	return zMult;
};

float PlaneEquation::constantValue() 
{
	DEBUG1	<< "float PlaneEquation::constantValue()\n";

	return d;
};

int PlaneEquation::inPlane(Vertex& v)
{
	DEBUG1	<< "int PlaneEquation::inPlane(Vertex& v)\n";

	Dimension residual=v.x()*xMult + v.y()*yMult + v.z()*zMult + d; 
	if (residual.value()<0.001)
		return 1;
	else
		cout <<"PlaneEquation::inPlane x y z failure values"
			<<v.x()<<" "<<v.y()<<" "<<v.z()<<"\n";
		return 0;
};

void PlaneEquation::printOn()
{
	DEBUG <<"void PlaneEquation::printOn()\n";

	cout<<"xCosine="<<xMult<<"\n";
	cout<<"yCosine="<<yMult<<"\n";
	cout<<"zCosine="<<zMult<<"\n";
	cout<<"constant="<< d <<"\n";
};
