#ifndef EKS_ORIENTATION_H
#define EKS_ORIENTATION_H

#include	"infrastructure/EKS.h"


class Orientation {
private:
/* Azimuth is the clockwise angle between the coordinate system Y
   axis and the projection of the polygon outward facing normal
   onto the XY plane. */

/* The plane elevation is the angle between the outward facing normal
   and the projection of this normal onto a plane parallel to the
   XY plane. */

	float p_azimuth;
	float p_elevation;
	float p_tilt;

public:
	Orientation(float a_azimuth, float a_elevation, float a_tilt);
	Orientation(Orientation& o);
	~Orientation();

	Orientation& operator=(Orientation& o);
	
	float azimuth();
	float elevation();
	float tilt();

friend	ostream&	operator<<(ostream& s, Orientation& o);
};

inline float Orientation::azimuth()
{
	return p_azimuth;
}

inline float Orientation::elevation()
{
	return p_elevation;
}

inline float Orientation::tilt()
{
	return p_tilt;
}
#endif
