#include	"transport/Orientation.h"


Orientation::Orientation(float a_azimuth, float a_elevation,
	float a_tilt)
{
	DEBUG << "Orientation(float az, float el, float a_tilt)\n";
	p_elevation=a_elevation;
	p_azimuth=a_azimuth;
	p_tilt=a_tilt;
}

Orientation::Orientation(Orientation& o)
{
	DEBUG << "Orientation(Orientation& o)\n";
	p_azimuth=o.p_azimuth;
	p_elevation=o.p_elevation;
	p_tilt=o.p_tilt;
}

Orientation::~Orientation()
{
	DEBUG << "Orientation::~Orientation()\n";
}

Orientation& Orientation::operator=(Orientation& o)
{
	DEBUG << "Orientation::operator=\n";
	if(this==&o) return *this;
	p_azimuth=o.p_azimuth;
	p_elevation=o.p_elevation;
	p_tilt=o.p_tilt;
	return (*this);
}


ostream&	operator<<(ostream& s, Orientation& o)
{
	DEBUG1	<< "operator<<(ostream& s, Orientation& o)\n";

	s << o.p_azimuth << "Z" << o.p_elevation << "L("
	  << o.p_tilt << "D)";
};
