#include	"transport/Node.h"


Node::Node() : the_arcs()
{
	DEBUG << "Node::Node()\n";
};

Node::Node(Node& a_node) : the_arcs()
{
	DEBUG << "Node::Node()\n";

	List_iterator(Arc)&	iter = a_node.arc_iterator();
	Arc*	n;
	while (n = iter(FORWARD))
		the_arcs.append(n);
};

Node::~Node()
{
	DEBUG << "Node::Node()\n";

	the_arcs.clear();
};


Node&	Node::operator=(Node& a_node)
{
	DEBUG1 << "Node&	Node::operator=(Node& a_node)\n";

	if (this = &a_node)   return *this;

	the_arcs.clear();			// shallow copy
	List_iterator(Arc)&	iter = a_node.arc_iterator();
	Arc*	n;
	while (n = iter(FORWARD))
		the_arcs.append(n);

	return *this;
};


void	Node::addArc(Arc* arc)
{
	DEBUG1 << "void   Node::addArc(Arc* arc)\n";

	the_arcs.append(arc);
};

List_iterator(Arc)	Node::arc_iterator()
{
	DEBUG1 << "List_iterator(Arc)   Node::arc_iterator()\n";

	List_iterator(Arc) iter(&the_arcs);
	return iter;
};



template_implement(List,Arc);
