#ifndef	MATRIX_H
#define MATRIX_H

#include	"transport/Vector.h"
class	MVector;


class Matrix : private Vector{
protected:
	int	row_size;
public:
	Matrix(int m, int n);
	Matrix(int m, int n, float val);
	Matrix(Matrix& m);
	~Matrix();

	MVector	operator[](int i);
	Matrix&	operator=(Matrix& m);
	Boolean	operator==(Matrix& m);
friend	Matrix	operator+(Matrix& v1, Matrix& v2);
friend	Matrix	operator-(Matrix& v1, Matrix& v2);
//friend	Matrix	operator*(Matrix& v1, Matrix& v2);

friend	ostream&	operator<<(ostream& s, Matrix& m);
};



class MVector {
protected:
friend	Matrix;
        float*  data;
        int     size;

        MVector(float* d, int s);
public:
	operator Vector();
        float&  operator[](int i);
friend  ostream&        operator<<(ostream& s, Matrix& m);
};
#endif
