#include	"transport/Matrix.h"


MVector::MVector(float* d, int s)	{ data = d; size = s; };
MVector::operator Vector()		{ return *((Vector*)this); };
float&  MVector::operator[](int i)	{ return data[i]; };



Matrix::Matrix(int m, int n) : Vector(m*n)	{ row_size = n; };

Matrix::Matrix(int m, int n, float val) : Vector(m*n, val)	{ row_size = n; };

Matrix::~Matrix()				{};

Matrix::Matrix(Matrix& m) : Vector(m.size)	{ row_size = m.row_size;
					 	 (void) Vector::operator=((Vector&)m);
						};

MVector	Matrix::operator[](int i)	{ return MVector(data+(i*row_size), row_size); };

Matrix&	Matrix::operator=(Matrix& m)	{ (void) Vector::operator=((Vector&)m);
					  return *this;
					};

Boolean	Matrix::operator==(Matrix& m)	{ return Vector::operator==((Vector&)m); };


Matrix	operator+(Matrix& m1, Matrix& m2)
{	Matrix m(m1.row_size, m1.size/m1.row_size);
	for (int i=0; i<m.size; i++)
		m.data[i] = m1.data[i] + m2.data[i];
	return m;
};

Matrix	operator-(Matrix& m1, Matrix& m2)
{	Matrix m(m1.row_size, m1.size/m1.row_size);
	for (int i=0; i<m.size; i++)
		m.data[i] = m1.data[i] - m2.data[i];
	return m;
};

ostream&	operator<<(ostream& s, Matrix& m)
{
	s << "[ " << m.row_size << " x " << m.size << "\n";
	for (int i = 0; i < m.row_size; i++) {
		s << "\t[" << m[i][0];
		for(int j = 1; j < m.size/m.row_size; j++)
			s << ", " << m[i][j];
		s << "]\n";
	};
	s << "]\n";

	return s;
};
