#ifndef LOCATION_H
#define LOCATION_H

#include	<stream.h>
#include	<string.h>
#include	"infrastructure/EKS.h"
class	APL;

/* 
** Location of a site expressed in terms of absolute latitude and
** longitude.
*/


class Location {
private:
	char* the_name;		// Name of the site.
	float the_latitude;	// Degrees, North of equator +ve.

	float the_longitude;	// Degrees, East of Greenwich Meridian +ve.
	float the_elevation;	// Elevation of the site from sea level (m).

public:
	Location(char* a_name, float a_latitude, float a_longitude, float a_elevation);
	Location(Location& l);
	Location(APL* theAPL);
	~Location();

	Location& operator=(Location& l);

	char*	name()			{ return the_name; }
	float	latitude()		{ return the_latitude; }
	float	longitude()		{ return the_longitude; }
	float	elevation()		{ return the_elevation; }

friend	ostream&	operator<<(ostream& s, Location& l);
};

#endif
