#include	"transport/Location.h"


Location::Location(char* a_name, float a_latitude, float a_longitude, float a_elevation)
{
	the_name=strdup(a_name);
	the_latitude=a_latitude;
	the_longitude=a_longitude;
	the_elevation=a_elevation;
};

Location::Location(Location& l)
{	
	the_name=strdup(l.name());
	the_latitude=l.latitude();
	the_longitude=l.longitude();
	the_elevation=l.elevation();
};

Location::Location(APL* theAPL)
{
	DEBUG << "Location(APL* theAPL)\n";
};

Location::~Location()
{
	delete the_name;
};

Location&	Location::operator=(Location& l)
{
	if (this==&l)   return (*this);

	delete the_name;
	the_name=strdup(l.name());
	the_latitude=l.latitude();
	the_longitude=l.longitude();
	the_elevation=l.elevation();

	return (*this);
};


ostream&	operator<<(ostream& s, Location& l)
{
	DEBUG1	<< "operator<<(ostream& s, Location& l)\n";

	s << l.the_name << "("
	  << l.the_latitude << "N " << l.the_longitude << "E "
	  << l.the_elevation << "m)";

	return s;
};
